/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.artipie.http.auth.AuthScheme;
import com.artipie.http.auth.Authentication;
import com.artipie.http.rq.RqHeaders;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import javax.crypto.Cipher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class CookiesAuthScheme
implements AuthScheme {
    private static final String SCHEME = "Cookie";

    public CompletionStage<AuthScheme.Result> authenticate(Iterable<Map.Entry<String, String>> headers) {
        return CompletableFuture.completedFuture(CookiesAuthScheme.session(Optional.ofNullable(CookiesAuthScheme.cookies((Iterable<String>)new RqHeaders(headers, SCHEME)).get("session"))));
    }

    private static Map<String, String> cookies(Iterable<String> raw) {
        HashMap<String, String> map = new HashMap<String, String>(0);
        for (String value : raw) {
            for (String pair : value.split(";")) {
                String[] parts = pair.split("=", 2);
                String key = parts[0].trim().toLowerCase(Locale.US);
                if (parts.length > 1 && !parts[1].isEmpty()) {
                    map.put(key, parts[1].trim());
                    continue;
                }
                map.remove(key);
            }
        }
        return map;
    }

    private static AuthScheme.Result session(Optional<String> encoded) {
        Optional<Object> user;
        String env = System.getenv("ARTIPIE_SESSION_KEY");
        if (env == null || encoded.isEmpty()) {
            user = Optional.empty();
        } else {
            try {
                byte[] key = Files.readAllBytes(Paths.get(env, new String[0]));
                PKCS8EncodedKeySpec spec = new PKCS8EncodedKeySpec(key);
                Cipher rsa = Cipher.getInstance("RSA/ECB/OAEPWithSHA1AndMGF1Padding");
                rsa.init(2, KeyFactory.getInstance("RSA").generatePrivate(spec));
                user = Optional.of(new Authentication.User(new String(rsa.doFinal(Hex.decodeHex((char[])encoded.get().toCharArray())), StandardCharsets.UTF_8)));
            }
            catch (IOException | GeneralSecurityException | DecoderException err) {
                Logger.error(CookiesAuthScheme.class, (String)"Failed to read session cookie: %[exception]s");
                throw new IllegalStateException("Failed to read session cookie", err);
            }
        }
        return new AuthScheme.Result(){

            public Optional<Authentication.User> user() {
                return user;
            }

            public String challenge() {
                return CookiesAuthScheme.SCHEME;
            }
        };
    }
}

