/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api;

import com.amihaiemil.eoyaml.Scalar;
import com.amihaiemil.eoyaml.Yaml;
import com.amihaiemil.eoyaml.YamlMapping;
import com.amihaiemil.eoyaml.YamlMappingBuilder;
import com.amihaiemil.eoyaml.YamlNode;
import com.artipie.ArtipieException;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.management.ConfigFiles;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cactoos.scalar.Unchecked;
import org.reactivestreams.Publisher;

public final class ApiRepoUpdateSlice
implements Slice {
    private static final Pattern PTN = Pattern.compile("/api/repos/(?<user>[^/.]+)");
    private final ConfigFiles configfile;

    public ApiRepoUpdateSlice(ConfigFiles configfile) {
        this.configfile = configfile;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (!matcher.matches()) {
            throw new IllegalStateException("Should match");
        }
        String user = matcher.group("user");
        return new AsyncResponse(new PublisherAs(body).asciiString().thenApply(form -> URLDecoder.decode(form, StandardCharsets.US_ASCII)).thenCompose(form -> {
            YamlMapping config = (YamlMapping)new Unchecked(() -> Yaml.createYamlInput((String)ApiRepoUpdateSlice.value(form, "config")).readYamlMapping()).value();
            YamlMapping repo = config.yamlMapping("repo");
            if (repo == null) {
                throw new ArtipieException("Repo section is required");
            }
            YamlNode type = repo.value("type");
            if (type == null || !Scalar.class.isAssignableFrom(type.getClass())) {
                throw new ArtipieException("Repository type required");
            }
            YamlMapping ystor = repo.yamlMapping("storage");
            String sstor = repo.string("storage");
            if (ystor == null && sstor == null) {
                throw new ArtipieException("Repository storage is required");
            }
            YamlMappingBuilder yrepo = Yaml.createYamlMappingBuilder().add("type", type);
            yrepo = ystor == null ? yrepo.add("storage", sstor) : yrepo.add("storage", (YamlNode)ystor);
            if (repo.value("permissions") != null) {
                yrepo = yrepo.add("permissions", repo.value("permissions"));
            }
            if (repo.value("settings") != null) {
                yrepo = yrepo.add("settings", repo.value("settings"));
            }
            String name = ApiRepoUpdateSlice.value(form, "repo");
            return this.configfile.save((Key)new Key.From(new String[]{user, String.format("%s.yaml", name)}), (Content)new Content.From(Yaml.createYamlMappingBuilder().add("repo", (YamlNode)yrepo.build()).build().toString().getBytes(StandardCharsets.UTF_8))).thenApply(nothing -> name);
        }).handle((name, throwable) -> {
            Object res = throwable == null ? new RsWithHeaders((Response)new RsWithStatus(RsStatus.FOUND), (Headers)new Headers.From("Location", String.format("/dashboard/%s/%s", user, name))) : (throwable.getCause() instanceof ArtipieException ? new RsWithBody((Response)new RsWithStatus(RsStatus.BAD_REQUEST), (CharSequence)String.format("Invalid yaml input:\n%s", throwable.getCause().getMessage()), StandardCharsets.UTF_8) : new RsWithStatus(RsStatus.INTERNAL_ERROR));
            return res;
        }));
    }

    private static String value(String payload, String name) {
        int start = payload.indexOf(String.format("%s=", name)) + name.length() + 1;
        int end = payload.indexOf(38, start);
        if (end == -1) {
            end = payload.length();
        }
        return payload.substring(start, end);
    }
}

