/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.artipie.asto.Key;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.rs.common.RsJson;
import com.artipie.management.ConfigFiles;
import com.artipie.management.RepoPermissions;
import com.artipie.management.api.artifactory.FromRqLine;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.reactivestreams.Publisher;

public final class GetPermissionSlice
implements Slice {
    private final RepoPermissions permissions;
    private final ConfigFiles configfile;

    public GetPermissionSlice(RepoPermissions permissions, ConfigFiles configfile) {
        this.permissions = permissions;
        this.configfile = configfile;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Optional<String> opt = new FromRqLine(line, FromRqLine.RqPattern.REPO).get();
        return opt.map(repo -> new AsyncResponse(this.configfile.exists((Key)new Key.From(repo)).thenCompose(exists -> {
            CompletionStage<Object> res = exists != false ? this.permissions.permissions((String)repo).thenCombine(this.permissions.patterns((String)repo), (perms, patterns) -> new RsJson((JsonStructure)GetPermissionSlice.response(patterns, perms, repo))) : CompletableFuture.completedStage(StandardRs.NOT_FOUND);
            return res;
        }))).orElse((Response)new RsWithStatus(RsStatus.BAD_REQUEST));
    }

    private static JsonObject response(Collection<RepoPermissions.PathPattern> patterns, Collection<RepoPermissions.PermissionItem> permissions, String repo) {
        return Json.createObjectBuilder().add("includesPattern", GetPermissionSlice.includesPattern(patterns)).add("repositories", (JsonValue)Json.createArrayBuilder().add(repo).build()).add("principals", Json.createObjectBuilder().add("users", (JsonValue)GetPermissionSlice.permissionsJson(permissions.stream().filter(new UsersFilter()))).add("groups", (JsonValue)GetPermissionSlice.permissionsJson(permissions.stream().filter(new UsersFilter().negate())))).build();
    }

    private static JsonObject permissionsJson(Stream<RepoPermissions.PermissionItem> permissions) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        permissions.forEach(perm -> {
            JsonArrayBuilder array = Json.createArrayBuilder();
            perm.permissions().stream().map(item -> {
                String mapped = item.equals("*") ? "m" : item.substring(0, 1);
                return mapped;
            }).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
            builder.add(perm.username().replaceAll("^/", ""), (JsonValue)array.build());
        });
        return builder.build();
    }

    private static String includesPattern(Collection<RepoPermissions.PathPattern> patterns) {
        return patterns.stream().map(RepoPermissions.PathPattern::string).findFirst().orElse("**");
    }

    private static final class UsersFilter
    implements Predicate<RepoPermissions.PermissionItem> {
        private UsersFilter() {
        }

        @Override
        public boolean test(RepoPermissions.PermissionItem item) {
            return item.username().charAt(0) != '/';
        }
    }
}

