/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.management.api.artifactory;

import com.artipie.asto.Key;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.common.RsJson;
import com.artipie.management.Storages;
import com.artipie.management.api.artifactory.KeyList;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import org.reactivestreams.Publisher;

public final class GetStorageSlice
implements Slice {
    private final Storages storages;
    private final Pattern path;

    public GetStorageSlice(Storages storages, Pattern path) {
        this.storages = storages;
        this.path = path;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        Request request = new Request(this.path, line);
        Key root = request.root();
        return new AsyncResponse(this.storages.repoStorage(request.repo()).thenCompose(repo -> ((CompletableFuture)repo.list(root).thenApply(list -> {
            KeyList keys = new KeyList(root);
            list.forEach(keys::add);
            return keys.print(new JsonOutput());
        })).thenApply(RsJson::new)));
    }

    public static final class Request {
        public static final Pattern PATH = Pattern.compile("/api/storage(?<target>/.+)");
        private final Pattern path;
        private final String line;

        public Request(Pattern path, String line) {
            this.path = path;
            this.line = line;
        }

        public String repo() {
            String target = this.target();
            Key root = this.root();
            return target.substring(1, target.length() - root.string().length() - 1);
        }

        public Key root() {
            String target = this.target();
            Matcher matcher = this.path.matcher(target);
            if (matcher.matches()) {
                return new Key.From(matcher.group(1).substring(1));
            }
            throw new IllegalArgumentException(String.format("Cannot find repo in path: '%s'", target));
        }

        private String target() {
            String rqpath = new RequestLineFrom(this.line).uri().getPath();
            Matcher matcher = PATH.matcher(rqpath);
            if (matcher.matches()) {
                return matcher.group("target");
            }
            throw new IllegalArgumentException(String.format("Invalid path: '%s'", rqpath));
        }
    }

    private static final class JsonOutput
    implements KeyList.KeysFormat<JsonObject> {
        private final JsonArrayBuilder builder;

        JsonOutput() {
            this(Json.createArrayBuilder());
        }

        private JsonOutput(JsonArrayBuilder builder) {
            this.builder = builder;
        }

        @Override
        public void add(Key item, boolean parent) {
            this.builder.add(Json.createObjectBuilder().add("uri", String.format("/%s", item.string())).add("folder", Boolean.toString(parent)));
        }

        @Override
        public JsonObject result() {
            return Json.createObjectBuilder().add("files", this.builder).build();
        }
    }
}

