/*
 * MIT License
 *
 * Copyright (c) 2020 Artipie
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */

package com.artipie.maven.file.checksum;

import com.artipie.maven.file.File;
import java.nio.ByteBuffer;
import org.cactoos.text.TextOf;
import org.reactivestreams.Publisher;

/**
 * MD5 checksum decorator for file. Represents a MD5 checksum file for a given
 * file.
 *
 * @since 0.2
 */
public final class Md5 extends Checksum {

    /**
     * Constructor.
     * @param file File to have its MD5 checksum calculated.
     */
    public Md5(final File file) {
        super(new TextOf("md5"), file);
    }

    @Override
    public Publisher<ByteBuffer> content() {
        throw new UnsupportedOperationException();
    }
}
