/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.metadata;

import com.artipie.maven.artifact.Artifact;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.cactoos.Text;
import org.cactoos.iterable.Reversed;
import org.cactoos.list.ListOf;
import org.cactoos.text.PrefixOf;
import org.cactoos.text.Split;
import org.cactoos.text.TextOf;
import org.cactoos.text.UncheckedText;
import org.reactivestreams.Publisher;
import org.xembly.Directives;
import org.xembly.Xembler;

public interface Metadata {
    public Publisher<ByteBuffer> content();

    public static class Maven
    implements Metadata {
        private static final String VERSION = "version";
        private static final String ARTIFACTID = "artifactId";
        private final Artifact artifact;

        public Maven(Artifact artifact) {
            this.artifact = artifact;
        }

        @Override
        public Publisher<ByteBuffer> content() {
            List versions = this.artifact.files().stream().map(file -> new UncheckedText((Text)new ListOf((Iterable)new Split((Text)new PrefixOf(new UncheckedText(file.name()).asString(), ".jar"), (Text)new TextOf("-"))).get(1)).asString()).distinct().sorted(Comparator.reverseOrder()).collect(Collectors.toList());
            String latest = (String)versions.get(0);
            return Flowable.just((Object)ByteBuffer.wrap(new Xembler((Iterable)new Directives().add((Object)"metadata").attr((Object)"xmlns", (Object)"http://maven.apache.org/METADATA/1.1.0").attr((Object)"xmlns:xsi", (Object)"http://www.w3.org/2001/XMLSchema-instance").attr((Object)"xsi:schemaLocation", (Object)"http://maven.apache.org/METADATA/1.1.0 http://maven.apache.org/xsd/metadata-1.1.0.xsd").add((Object)"groupId").up().add((Object)ARTIFACTID).up().add((Object)VERSION).set((Object)latest).up().add((Object)"versioning").add((Object)"latest").set((Object)latest).up().add((Object)"release").set((Object)latest).up().add((Object)"snapshot").add((Object)"timestamp").up().add((Object)"buildNumber").up().add((Object)"localCopy").up().up().add((Object)"versions").append(() -> {
                Directives dirs = new Directives();
                new Reversed((Iterable)versions).forEach(version -> dirs.add((Object)VERSION).set(version).up());
                return dirs.iterator();
            }).up().add((Object)"lastUpdated").up().add((Object)"snapshotVersions").add((Object)"snapshotVersion").add((Object)"classifier").up().add((Object)"extension").up().add((Object)"value").up().add((Object)"updated").up().up().up().up().add((Object)"plugins").add((Object)"plugin").add((Object)"name").up().add((Object)"prefix").up().add((Object)ARTIFACTID).up().up()).xmlQuietly().replaceAll("(?m)^\\s+", "").replace("\n", "").replace("\r", "").getBytes()));
        }
    }
}

