/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.xembly.Directive;
import org.xembly.Directives;
import org.xembly.Xembler;

final class MavenMetadata {
    private final Directives dirs;

    MavenMetadata(Iterable<Directive> source) {
        this.dirs = new Directives(source);
    }

    public MavenMetadata versions(Set<String> items) {
        Directives copy = new Directives((Iterable)this.dirs);
        copy.xpath((Object)"/metadata").push().xpath((Object)"versioning").remove().pop().xpath((Object)"/metadata").add((Object)"versioning");
        items.stream().max(Comparator.naturalOrder()).ifPresent(latest -> copy.add((Object)"latest").set(latest).up());
        items.stream().filter(version -> !version.endsWith("SNAPSHOT")).max(Comparator.naturalOrder()).ifPresent(latest -> copy.add((Object)"release").set(latest).up());
        copy.add((Object)"versions");
        items.forEach(version -> copy.add((Object)"version").set(version).up());
        copy.up();
        copy.addIf((Object)"lastUpdated").set((Object)Instant.now().toEpochMilli()).up();
        copy.up();
        return new MavenMetadata((Iterable<Directive>)copy);
    }

    public CompletionStage<Void> save(Storage storage, Key base) {
        return CompletableFuture.supplyAsync(() -> new Xembler((Iterable)this.dirs).xmlQuietly().getBytes(StandardCharsets.UTF_8)).thenCompose(data -> storage.save((Key)new Key.From(base, new String[]{"maven-metadata.xml"}), (Content)new Content.From(data)));
    }
}

