/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Connection;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.slice.SliceUpload;
import com.artipie.maven.Maven;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class UpdateMavenSlice
implements Slice {
    private static final Pattern PTN_META = Pattern.compile("^/(?<pkg>.+)/maven-metadata.xml$");
    private final Slice origin;
    private final Maven maven;

    UpdateMavenSlice(Storage storage) {
        this.origin = new SliceUpload(storage);
        this.maven = new Maven(storage);
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> head, Publisher<ByteBuffer> body) {
        RequestLineFrom reqline = new RequestLineFrom(line);
        String path = reqline.uri().getPath();
        Matcher matcher = PTN_META.matcher(path);
        return new ResponseWrap(this.origin.response(line, head, body), () -> {
            CompletionStage<Object> res = matcher.matches() ? this.maven.update((Key)new Key.From(matcher.group("pkg"))) : CompletableFuture.completedFuture(null);
            return res;
        });
    }

    private static final class ResponseWrap
    implements Response {
        private final Response origin;
        private final Supplier<CompletionStage<Void>> update;

        ResponseWrap(Response response, Supplier<CompletionStage<Void>> update) {
            this.origin = response;
            this.update = update;
        }

        public CompletionStage<Void> send(Connection connection) {
            return this.origin.send(connection).thenCompose(none -> this.update.get());
        }
    }
}

