/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.repository;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.maven.repository.ArtifactNotFoundException;
import com.artipie.maven.repository.ProxyCache;
import com.artipie.maven.repository.Repository;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Flowable;
import io.reactivex.Single;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.http.client.utils.URIBuilder;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.reactive.client.ReactiveRequest;
import org.reactivestreams.Publisher;

public final class RpRemote
implements Repository {
    private final URI remote;
    private final HttpClient http;
    private final ProxyCache cache;

    public RpRemote(HttpClient http, URI uri) {
        this(http, uri, ProxyCache.NOP);
    }

    public RpRemote(HttpClient http, URI uri, ProxyCache cache) {
        this.remote = uri;
        this.http = http;
        this.cache = cache;
    }

    @Override
    public CompletionStage<? extends Content> artifact(URI uri) {
        URIBuilder builder = new URIBuilder(this.remote);
        builder.setPath(Paths.get(builder.getPath(), uri.getPath()).normalize().toString());
        Request request = this.http.newRequest(builder.toString());
        return this.cache.load((Key)new Key.From(RpRemote.relativePath(uri)), () -> (CompletionStage)Flowable.fromPublisher((Publisher)ReactiveRequest.newBuilder((Request)request).build().response((rsp, body) -> {
            Single res = rsp.getStatus() == 200 ? Single.just((Object)new Content.From(Optional.ofNullable(rsp.getHeaders().get("Content-Size")).map(Long::parseLong), (Publisher)Flowable.fromPublisher((Publisher)body).map(chunk -> chunk.buffer))) : (rsp.getStatus() == 404 ? Single.error((Throwable)new ArtifactNotFoundException(builder.getPath())) : Single.error((Throwable)new Exception(String.format("Failed to fetch remote repo: %d", rsp.getStatus()))));
            return res.toFlowable();
        })).singleOrError().to(SingleInterop.get()));
    }

    private static String relativePath(URI uri) {
        try {
            return new URI(uri.getScheme(), null, uri.getHost(), uri.getPort(), null, null, null).relativize(uri).getPath();
        }
        catch (URISyntaxException err) {
            throw new IllegalStateException("Invalid URI", err);
        }
    }
}

