/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.cache.Cache;
import com.artipie.asto.cache.CacheControl;
import com.artipie.asto.cache.DigestVerification;
import com.artipie.asto.ext.Digests;
import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.maven.http.ProxyPublisher;
import com.artipie.maven.http.RepoHead;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.reactivestreams.Publisher;

final class CachedProxySlice
implements Slice {
    private static final Pattern CHECKSUM_PATTERN = Pattern.compile("x-checksum-(sha1|sha256|sha512|md5)", 2);
    private static final Map<String, String> DIGEST_NAMES = Map.of("sha1", "SHA-1", "sha256", "SHA-256", "sha512", "SHA-512", "md5", "MD5");
    private final Slice client;
    private final Cache cache;

    CachedProxySlice(Slice client, Cache cache) {
        this.client = client;
        this.cache = cache;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom req = new RequestLineFrom(line);
        KeyFromPath key = new KeyFromPath(req.uri().getPath());
        return new AsyncResponse(new RepoHead(this.client).head(req.uri().getPath()).thenCompose(arg_0 -> this.lambda$response$2((Key)key, line, body, arg_0)));
    }

    private static CacheControl checksumControl(Header header) {
        CacheControl.Standard res;
        Matcher matcher = CHECKSUM_PATTERN.matcher(header.getKey());
        if (matcher.matches()) {
            try {
                res = new DigestVerification((Supplier)new Digests.FromString(DIGEST_NAMES.get(matcher.group(1).toLowerCase(Locale.US))).get(), Hex.decodeHex((char[])header.getValue().toCharArray()));
            }
            catch (DecoderException err) {
                throw new IllegalStateException("Invalid digest hex", err);
            }
        } else {
            res = CacheControl.Standard.ALWAYS;
        }
        return res;
    }

    private /* synthetic */ CompletionStage lambda$response$2(Key key, String line, Publisher body, Headers head) {
        return this.cache.load(key, () -> CompletableFuture.completedFuture(new Content.From((Publisher)new ProxyPublisher(this.client.response(line, (Iterable)Headers.EMPTY, body)))), (CacheControl)new CacheControl.All((Collection)StreamSupport.stream(head.spliterator(), false).map(Header::new).map(CachedProxySlice::checksumControl).collect(Collectors.toUnmodifiableList()))).thenApply(pub -> new RsWithBody((Response)StandardRs.OK, pub));
    }
}

