/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.cache.Cache;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsFull;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rt.ByMethodsRule;
import com.artipie.http.rt.RtPath;
import com.artipie.http.rt.RtRule;
import com.artipie.http.rt.RtRulePath;
import com.artipie.http.rt.SliceRoute;
import com.artipie.http.slice.SliceSimple;
import com.artipie.maven.http.CachedProxySlice;
import com.artipie.maven.http.HeadProxySlice;
import io.reactivex.Flowable;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.http.client.utils.URIBuilder;
import org.reactivestreams.Publisher;

public final class MavenProxySlice
extends Slice.Wrap {
    public MavenProxySlice(ClientSlices clients, URI remote) {
        this(clients, remote, Cache.NOP);
    }

    public MavenProxySlice(ClientSlices clients, URI remote, Cache cache) {
        super((Slice)new SliceRoute(new RtPath[]{new RtRulePath((RtRule)new ByMethodsRule(new RqMethod[]{RqMethod.HEAD}), (Slice)new HeadProxySlice(new ClientSlice(clients, remote))), new RtRulePath((RtRule)new ByMethodsRule(new RqMethod[]{RqMethod.GET}), (Slice)new CachedProxySlice(new ClientSlice(clients, remote), cache)), new RtRulePath(RtRule.FALLBACK, (Slice)new SliceSimple((Response)new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED)))}));
    }

    private static final class ClientSlice
    implements Slice {
        private final ClientSlices clients;
        private final URI remote;

        ClientSlice(ClientSlices clients, URI remote) {
            this.clients = clients;
            this.remote = remote;
        }

        public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
            Slice slice;
            String scheme;
            String host = this.remote.getHost();
            int port = this.remote.getPort();
            switch (scheme = this.remote.getScheme()) {
                case "https": {
                    slice = this.clients.https(host, port);
                    break;
                }
                case "http": {
                    slice = this.clients.http(host, port);
                    break;
                }
                default: {
                    throw new IllegalStateException(String.format("Scheme '%s' is not supported", scheme));
                }
            }
            RequestLineFrom rqline = new RequestLineFrom(line);
            URI uri = rqline.uri();
            CompletableFuture promise = new CompletableFuture();
            slice.response(new RequestLine(rqline.method().value(), new URIBuilder(uri).setPath(ClientSlice.concatPaths(this.remote.getPath(), uri.getPath())).toString(), rqline.version()).toString(), headers, body).send((status, rsheaders, rsbody) -> {
                CompletableFuture terminated = new CompletableFuture();
                Flowable termbody = Flowable.fromPublisher((Publisher)rsbody).doOnError(terminated::completeExceptionally).doOnTerminate(() -> terminated.complete(null));
                promise.complete(new RsFull(status, (Iterable)rsheaders, (Publisher)termbody));
                return terminated;
            });
            return new AsyncResponse(promise);
        }

        private static String concatPaths(String ... paths) {
            String rel = Stream.of(paths).map(path -> path.replaceAll("(?:^/|/$)", "")).flatMap(path -> Arrays.stream(path.split("/"))).filter(part -> !part.isEmpty()).collect(Collectors.joining("/"));
            return String.format("/%s", rel);
        }
    }
}

