/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.http.Headers;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.Header;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.maven.ArtifactNotFoundException;
import com.artipie.maven.Repository;
import com.jcabi.log.Logger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletionException;
import org.reactivestreams.Publisher;

public final class RemoteDownloadSlice
implements Slice {
    private final Repository repo;

    public RemoteDownloadSlice(Repository repo) {
        this.repo = repo;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse(this.repo.artifact(new RequestLineFrom(line).uri()).thenApply(content -> new RsWithStatus((Response)new RsWithHeaders((Response)new RsWithBody((Publisher)content), content.size().map(size -> new Header("Content-Length", Long.toString(size))).map(Headers.From::new).orElse(Headers.EMPTY)), RsStatus.OK)).exceptionally(err -> {
            StandardRs rsp;
            Throwable source = err instanceof CompletionException ? ((CompletionException)CompletionException.class.cast(err)).getCause() : err;
            if (source instanceof ArtifactNotFoundException) {
                rsp = StandardRs.NOT_FOUND;
            } else {
                Logger.error((Object)this, (String)"Failed to download artifact: %[exception]s", (Object[])new Object[]{source});
                rsp = new RsWithStatus((Response)new RsWithBody((CharSequence)err.getMessage(), StandardCharsets.UTF_8), RsStatus.INTERNAL_ERROR);
            }
            return rsp;
        }));
    }
}

