/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Content;
import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.SubStorage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.ContentWithSize;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.maven.Maven;
import com.artipie.maven.ValidUpload;
import com.artipie.maven.asto.AstoMaven;
import com.artipie.maven.asto.AstoValidUpload;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.cactoos.list.ListOf;
import org.reactivestreams.Publisher;

final class UpdateMavenSlice
implements Slice {
    static final Key TEMP = new Key.From(".upload");
    private static final Pattern PTN_META = Pattern.compile("^/(?<pkg>.+)/maven-metadata.xml$");
    private static final String SNAPSHOT_METADATA = "-SNAPSHOT/maven-metadata.xml";
    private final Storage storage;
    private final Maven maven;
    private final ValidUpload validator;

    UpdateMavenSlice(Storage storage, Maven maven, ValidUpload validator) {
        this.storage = storage;
        this.maven = maven;
        this.validator = validator;
    }

    UpdateMavenSlice(Storage storage) {
        this(storage, new AstoMaven(storage), new AstoValidUpload(storage));
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> head, Publisher<ByteBuffer> body) {
        RequestLineFrom reqline = new RequestLineFrom(line);
        String path = reqline.uri().getPath();
        Matcher matcher = PTN_META.matcher(path);
        SubStorage temp = new SubStorage(TEMP, this.storage);
        return new AsyncResponse(temp.save((Key)new KeyFromPath(new RequestLineFrom(line).uri().getPath()), (Content)new ContentWithSize(body, head)).thenCompose(arg_0 -> this.lambda$response$8(matcher, path, (Storage)temp, arg_0)));
    }

    private static CompletableFuture<Void> remove(Storage asto, Collection<Key> items) {
        return CompletableFuture.allOf((CompletableFuture[])items.stream().map(arg_0 -> ((Storage)asto).delete(arg_0)).toArray(CompletableFuture[]::new));
    }

    private /* synthetic */ CompletionStage lambda$response$8(Matcher matcher, String path, Storage temp, Void ignored) {
        CompletionStage<Object> res;
        if (matcher.matches() && !path.endsWith(SNAPSHOT_METADATA)) {
            Key.From location = new Key.From(matcher.group("pkg"));
            res = this.validator.validate((Key)new Key.From(TEMP, (Key)location), (Key)location).thenCompose(arg_0 -> this.lambda$response$7((Key)location, temp, arg_0));
        } else {
            res = CompletableFuture.completedFuture(new RsWithStatus(RsStatus.CREATED));
        }
        return res;
    }

    private /* synthetic */ CompletionStage lambda$response$7(Key location, Storage temp, Boolean valid) {
        CompletionStage upd = valid != false ? this.storage.exclusively(location, target -> this.maven.update((Key)new Key.From(TEMP, location), location).thenCompose(nothing -> temp.list(location)).thenCompose(list -> new Copy(temp, (List)new ListOf((Iterable)list)).copy(target).thenCompose(nothing -> UpdateMavenSlice.remove(temp, list).thenApply(any -> new RsWithStatus(RsStatus.CREATED))))) : ((CompletableFuture)temp.list(location).thenCompose(items -> UpdateMavenSlice.remove(temp, items))).thenApply(nothing -> new RsWithStatus(RsStatus.BAD_REQUEST));
        return upd;
    }
}

