/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.maven.ValidUpload;
import com.artipie.maven.asto.RepositoryChecksums;
import com.artipie.maven.metadata.ArtifactsMetadata;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Pattern;

public final class AstoValidUpload
implements ValidUpload {
    private static final Pattern PTN_ARTIFACT = Pattern.compile(".+\\.(?:pom|jar|war|ear|rar|aar)");
    private final Storage storage;

    public AstoValidUpload(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<Boolean> validate(Key upload, Key artifact) {
        return this.validateMetadata(upload, artifact).thenCompose(valid -> {
            CompletionStage<Boolean> res = CompletableFuture.completedStage(valid);
            if (valid.booleanValue()) {
                res = this.validateChecksums(upload);
            }
            return res;
        });
    }

    private CompletionStage<Boolean> validateMetadata(Key upload, Key artifact) {
        ArtifactsMetadata metadata = new ArtifactsMetadata(this.storage);
        String meta = "maven-metadata.xml";
        return ((CompletableFuture)this.storage.exists((Key)new Key.From(artifact, new String[]{"maven-metadata.xml"})).thenCompose(exists -> {
            CompletionStage<Boolean> res = exists != false ? metadata.groupAndArtifact(upload).thenCompose(existing -> metadata.groupAndArtifact(artifact).thenApply(uploaded -> uploaded.equals(existing))) : CompletableFuture.completedStage(true);
            return res;
        })).thenCompose(same -> {
            CompletionStage res = same != false ? (CompletionStage)this.validateArtifactChecksums((Key)new Key.From(upload, new String[]{"maven-metadata.xml"})).to(SingleInterop.get()) : CompletableFuture.completedStage(false);
            return res;
        });
    }

    private CompletionStage<Boolean> validateChecksums(Key upload) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.storage);
        return new ArtifactsMetadata(this.storage).maxVersion(upload).thenCompose(arg_0 -> this.lambda$validateChecksums$8(upload, (RxStorage)rxsto, arg_0));
    }

    private Single<Boolean> validateArtifactChecksums(Key artifact) {
        return SingleInterop.fromFuture(new RepositoryChecksums(this.storage).checksums(artifact)).map(Map::entrySet).flatMapObservable(Observable::fromIterable).flatMapSingle(entry -> SingleInterop.fromFuture((CompletionStage)this.storage.value(artifact).thenCompose(content -> new ContentDigest(content, (Supplier)Digests.valueOf((String)((String)entry.getKey()).toUpperCase(Locale.US))).hex().thenApply(hex -> hex.equals(entry.getValue()))))).all(equal -> equal);
    }

    private /* synthetic */ CompletionStage lambda$validateChecksums$8(Key upload, RxStorage rxsto, String version) {
        Key.From pckg = new Key.From(upload, new String[]{version});
        return (CompletionStage)rxsto.list((Key)pckg).flatMapObservable(Observable::fromIterable).filter(key -> PTN_ARTIFACT.matcher(key.string()).matches()).flatMapSingle(this::validateArtifactChecksums).reduce(new ArrayList(5), (list, res) -> {
            list.add(res);
            return list;
        }).map(array -> !array.isEmpty() && !array.contains(false)).to(SingleInterop.get());
    }
}

