/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.KeyLastPart;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.headers.ContentLength;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.maven.http.ArtifactGetResponse;
import com.artipie.maven.http.ArtifactHeadResponse;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class LocalMavenSlice
implements Slice {
    private static final Pattern PTN_ARTIFACT = Pattern.compile(".+\\.(?:pom|jar|war|ear|rar|aar|xml)");
    private final Storage storage;

    LocalMavenSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RequestLineFrom rline = new RequestLineFrom(line);
        KeyFromPath key = new KeyFromPath(rline.uri().getPath());
        Matcher match = PTN_ARTIFACT.matcher(new KeyLastPart((Key)key).get());
        Response response = match.matches() ? this.artifactResponse(rline.method(), (Key)key) : this.plainResponse(rline.method(), (Key)key);
        return response;
    }

    private Response artifactResponse(RqMethod method, Key artifact) {
        Object response;
        switch (method) {
            case GET: {
                response = new ArtifactGetResponse(this.storage, artifact);
                break;
            }
            case HEAD: {
                response = new ArtifactHeadResponse(this.storage, artifact);
                break;
            }
            default: {
                response = new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
            }
        }
        return response;
    }

    private Response plainResponse(RqMethod method, Key key) {
        Object response;
        switch (method) {
            case GET: {
                response = new PlainResponse(this.storage, key, () -> new AsyncResponse(this.storage.value(key).thenApply(RsWithBody::new)));
                break;
            }
            case HEAD: {
                response = new PlainResponse(this.storage, key, () -> new AsyncResponse(this.storage.size(key).thenApply(size -> new RsWithHeaders((Response)StandardRs.OK, new Map.Entry[]{new ContentLength(size.toString())}))));
                break;
            }
            default: {
                response = new RsWithStatus(RsStatus.METHOD_NOT_ALLOWED);
            }
        }
        return response;
    }

    private static final class PlainResponse
    extends Response.Wrap {
        PlainResponse(Storage storage, Key key, Supplier<? extends Response> actual) {
            super((Response)new AsyncResponse(storage.exists(key).thenApply(exists -> {
                Object res = exists != false ? (Response)actual.get() : StandardRs.NOT_FOUND;
                return res;
            })));
        }
    }
}

