/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.http.Response;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class ProxyPublisher
implements Publisher<ByteBuffer> {
    private final Response response;

    ProxyPublisher(Response response) {
        this.response = response;
    }

    public void subscribe(Subscriber<? super ByteBuffer> subscriber) {
        this.response.send((status, headers, body) -> {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            body.subscribe((Subscriber)new CompletableSubscriber(subscriber, future));
            return future;
        });
    }

    private static final class CompletableSubscription
    implements Subscription {
        private final Subscription origin;
        private final CompletableFuture<Void> future;

        CompletableSubscription(Subscription origin, CompletableFuture<Void> future) {
            this.origin = origin;
            this.future = future;
        }

        public void request(long num) {
            this.origin.request(num);
        }

        public void cancel() {
            try {
                this.origin.cancel();
            }
            finally {
                this.future.cancel(true);
            }
        }
    }

    private static final class CompletableSubscriber
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> origin;
        private final CompletableFuture<Void> future;

        CompletableSubscriber(Subscriber<? super ByteBuffer> origin, CompletableFuture<Void> future) {
            this.origin = origin;
            this.future = future;
        }

        public void onSubscribe(Subscription subscription) {
            this.origin.onSubscribe((Subscription)new CompletableSubscription(subscription, this.future));
        }

        public void onNext(ByteBuffer buffer) {
            this.origin.onNext((Object)buffer);
        }

        public void onError(Throwable err) {
            try {
                this.origin.onError(err);
            }
            finally {
                this.future.completeExceptionally(err);
            }
        }

        public void onComplete() {
            try {
                this.origin.onComplete();
            }
            finally {
                this.future.complete(null);
            }
        }
    }
}

