/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.metadata;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.maven.metadata.Version;
import com.jcabi.xml.XMLDocument;
import java.nio.charset.StandardCharsets;
import java.util.Comparator;
import java.util.concurrent.CompletionStage;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class ArtifactsMetadata {
    public static final String MAVEN_METADATA = "maven-metadata.xml";
    private final Storage storage;

    public ArtifactsMetadata(Storage storage) {
        this.storage = storage;
    }

    public CompletionStage<String> maxVersion(Key location) {
        return this.storage.value((Key)new Key.From(location, new String[]{MAVEN_METADATA})).thenCompose(content -> new PublisherAs(content).string(StandardCharsets.UTF_8).thenApply(metadata -> new XMLDocument(metadata).xpath("//version/text()").stream().max(Comparator.comparing(Version::new)).orElseThrow(() -> new IllegalArgumentException("Maven metadata xml not valid: latest version not found"))));
    }

    public CompletionStage<Pair<String, String>> groupAndArtifact(Key location) {
        return this.storage.value((Key)new Key.From(location, new String[]{MAVEN_METADATA})).thenCompose(content -> new PublisherAs(content).string(StandardCharsets.UTF_8).thenApply(XMLDocument::new).thenApply(doc -> new ImmutablePair((Object)((String)doc.xpath("//groupId/text()").get(0)), (Object)((String)doc.xpath("//artifactId/text()").get(0)))));
    }
}

