/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.asto;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.asto.rx.RxStorageWrapper;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.cactoos.map.MapEntry;

public final class RepositoryChecksums {
    private static final Set<String> SUPPORTED_ALGS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("sha512", "sha256", "sha1", "md5")));
    private final Storage repo;

    public RepositoryChecksums(Storage repo) {
        this.repo = repo;
    }

    public CompletionStage<? extends Map<String, String>> checksums(Key artifact) {
        RxStorageWrapper rxsto = new RxStorageWrapper(this.repo);
        return (CompletionStage)rxsto.list(artifact).flatMapObservable(Observable::fromIterable).filter(key -> SUPPORTED_ALGS.contains(RepositoryChecksums.extension(key))).flatMapSingle(item -> SingleInterop.fromFuture((CompletionStage)((CompletableFuture)this.repo.value(item).thenCompose(pub -> new PublisherAs(pub).asciiString())).thenApply(hash -> new MapEntry((Object)RepositoryChecksums.extension(item), hash)))).reduce(new HashMap(), (map, hash) -> {
            map.put((String)hash.getKey(), (String)hash.getValue());
            return map;
        }).to(SingleInterop.get());
    }

    public CompletionStage<Void> generate(Key artifact) {
        return CompletableFuture.allOf((CompletableFuture[])SUPPORTED_ALGS.stream().map(alg -> this.repo.value(artifact).thenCompose(content -> new ContentDigest(content, (Supplier)Digests.valueOf((String)alg.toUpperCase(Locale.US))).hex().thenCompose(hex -> this.repo.save((Key)new Key.From(String.format("%s.%s", artifact.string(), alg)), (Content)new Content.From(hex.getBytes(StandardCharsets.UTF_8)))))).toArray(CompletableFuture[]::new));
    }

    private static String extension(Key key) {
        String src = key.string();
        return src.substring(src.lastIndexOf(46) + 1).toLowerCase(Locale.US);
    }
}

