/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.maven.Maven;
import com.artipie.maven.ValidUpload;
import com.artipie.maven.http.UploadSlice;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.reactivestreams.Publisher;

public final class PutMetadataChecksumSlice
implements Slice {
    static final Pattern PTN = Pattern.compile("^/(?<pkg>.+)/maven-metadata.xml.(?<alg>md5|sha1|sha256|sha512)");
    private static final Response BAD_REQUEST = new RsWithStatus(RsStatus.BAD_REQUEST);
    private final Storage asto;
    private final ValidUpload valid;
    private final Maven mvn;

    public PutMetadataChecksumSlice(Storage asto, ValidUpload valid, Maven mvn) {
        this.asto = asto;
        this.valid = valid;
        this.mvn = mvn;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus res;
        Matcher matcher = PTN.matcher(new RequestLineFrom(line).uri().getPath());
        if (matcher.matches()) {
            String alg = matcher.group("alg");
            String pkg = matcher.group("pkg");
            res = new AsyncResponse(this.findAndSave(body, alg, pkg).thenCompose(key -> {
                CompletionStage<Object> resp;
                if (key.isPresent() && ((Key)key.get()).parent().isPresent() && ((Key)((Key)key.get()).parent().get()).parent().isPresent()) {
                    Key location = (Key)((Key)((Key)key.get()).parent().get()).parent().get();
                    resp = this.valid.ready(location).thenCompose(ready -> {
                        CompletionStage<Object> action = ready != false ? this.validateAndUpdate(pkg, location) : CompletableFuture.completedFuture(new RsWithStatus(RsStatus.CREATED));
                        return action;
                    });
                } else {
                    resp = CompletableFuture.completedFuture(BAD_REQUEST);
                }
                return resp;
            }));
        } else {
            res = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return res;
    }

    private CompletionStage<Response> validateAndUpdate(String pkg, Key location) {
        return this.valid.validate(location, (Key)new Key.From(pkg)).thenCompose(correct -> {
            CompletionStage<Response> upd = correct != false ? this.mvn.update(location, (Key)new Key.From(pkg)).thenApply(ignored -> new RsWithStatus(RsStatus.CREATED)) : CompletableFuture.completedFuture(BAD_REQUEST);
            return upd;
        });
    }

    private CompletionStage<Optional<Key>> findAndSave(Publisher<ByteBuffer> body, String alg, String pkg) {
        return new PublisherAs(body).asciiString().thenCompose(sum -> (CompletionStage)new RxStorageWrapper(this.asto).list((Key)new Key.From(UploadSlice.TEMP, new String[]{pkg})).flatMapObservable(Observable::fromIterable).filter(item -> item.string().endsWith("maven-metadata.xml")).flatMapSingle(item -> Single.fromFuture((Future)((Object)((CompletableFuture)this.asto.value(item).thenCompose(pub -> new ContentDigest(pub, (Supplier)Digests.valueOf((String)alg.toUpperCase(Locale.US))).hex())).thenApply(hex -> new ImmutablePair(item, hex))))).filter(pair -> ((String)pair.getValue()).equals(sum)).singleOrError().flatMap(pair -> SingleInterop.fromFuture((CompletionStage)this.asto.save((Key)new Key.From(String.format("%s.%s", ((Key)pair.getKey()).string(), alg)), (Content)new Content.From(sum.getBytes(StandardCharsets.US_ASCII))).thenApply(nothing -> Optional.of((Key)pair.getKey())))).onErrorReturn(ignored -> Optional.empty()).to(SingleInterop.get()));
    }
}

