/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.asto;

import com.artipie.asto.Copy;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.SubStorage;
import com.artipie.asto.ext.KeyLastPart;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.maven.Maven;
import com.artipie.maven.asto.RepositoryChecksums;
import com.artipie.maven.metadata.MavenMetadata;
import com.jcabi.xml.XMLDocument;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import org.w3c.dom.Node;
import org.xembly.Directives;

public final class AstoMaven
implements Maven {
    private static final String MAVEN_META = "maven-metadata.xml";
    private final Storage storage;

    public AstoMaven(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<Void> update(Key upload, Key artifact) {
        return this.storage.exclusively(artifact, target -> ((CompletableFuture)((CompletableFuture)((CompletableFuture)((CompletableFuture)target.list(artifact).thenApply(items -> items.stream().map(item -> item.string().replaceAll(String.format("%s/", artifact.string()), "").split("/")[0]).filter(item -> !item.startsWith("maven-metadata")).collect(Collectors.toSet()))).thenCompose(versions -> ((CompletableFuture)this.storage.value((Key)new Key.From(upload, new String[]{"meta", MAVEN_META})).thenCompose(pub -> new PublisherAs(pub).asciiString())).thenCompose(str -> {
            versions.add(new KeyLastPart(upload).get());
            return new MavenMetadata(Directives.copyOf((Node)new XMLDocument(str).node())).versions((Set<String>)versions).save(this.storage, (Key)new Key.From(upload, new String[]{"meta"}));
        }))).thenCompose(meta -> new RepositoryChecksums(this.storage).generate((Key)meta))).thenCompose(nothing -> this.moveToTheRepository(upload, (Storage)target, artifact))).thenCompose(nothing -> this.storage.deleteAll(upload)));
    }

    private CompletableFuture<Void> moveToTheRepository(Key upload, Storage target, Key artifact) {
        SubStorage sub = new SubStorage((Key)new Key.From(upload, new String[]{"meta"}), this.storage);
        SubStorage subversion = new SubStorage((Key)upload.parent().get(), this.storage);
        return ((CompletableFuture)sub.list(Key.ROOT).thenCompose(arg_0 -> AstoMaven.lambda$moveToTheRepository$11((Storage)sub, artifact, target, arg_0))).thenCompose(arg_0 -> AstoMaven.lambda$moveToTheRepository$14((Storage)subversion, artifact, target, arg_0));
    }

    private static /* synthetic */ CompletionStage lambda$moveToTheRepository$14(Storage subversion, Key artifact, Storage target, Void nothing) {
        return subversion.list(Key.ROOT).thenCompose(list -> new Copy(subversion, (Collection)list.stream().filter(key -> !key.string().contains(String.format("/%s/", "meta"))).collect(Collectors.toList())).copy((Storage)new SubStorage(artifact, target)));
    }

    private static /* synthetic */ CompletionStage lambda$moveToTheRepository$11(Storage sub, Key artifact, Storage target, Collection list) {
        return new Copy(sub, (Collection)list.stream().filter(key -> key.string().contains(MAVEN_META)).collect(Collectors.toList())).copy((Storage)new SubStorage(artifact, target));
    }
}

