/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.asto;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.maven.ValidUpload;
import com.artipie.maven.asto.RepositoryChecksums;
import com.artipie.maven.metadata.ArtifactsMetadata;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import io.reactivex.Observable;
import io.reactivex.Single;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class AstoValidUpload
implements ValidUpload {
    private static final Pattern PTN_ARTIFACT = Pattern.compile(".+\\.(?:pom|jar|war|ear|rar|aar)");
    private static final Pattern PTN_META = Pattern.compile(".+/meta/maven-metadata.xml.(?:md5|sha1|sha256|sha512)");
    private final Storage storage;

    public AstoValidUpload(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletionStage<Boolean> validate(Key upload, Key artifact) {
        return this.validateMetadata(upload, artifact).thenCompose(valid -> {
            CompletionStage<Boolean> res = CompletableFuture.completedStage(valid);
            if (valid.booleanValue()) {
                res = this.validateChecksums(upload);
            }
            return res;
        });
    }

    @Override
    public CompletionStage<Boolean> ready(Key location) {
        return ((CompletableFuture)this.storage.list(location).thenApply(list -> list.stream().map(Key::string).collect(Collectors.toList()))).thenApply(list -> list.stream().filter(key -> PTN_ARTIFACT.matcher((CharSequence)key).matches()).findAny().map(item -> list.stream().filter(key -> key.contains((CharSequence)item) && key.length() > item.length()).map(key -> key.substring(key.lastIndexOf(46))).collect(Collectors.toList())).map(algs -> list.stream().filter(item -> PTN_META.matcher((CharSequence)item).matches()).map(key -> key.substring(key.lastIndexOf(46))).collect(Collectors.toList()).equals(algs)).orElse(false));
    }

    private CompletionStage<Boolean> validateMetadata(Key upload, Key artifact) {
        ArtifactsMetadata metadata = new ArtifactsMetadata(this.storage);
        String meta = "maven-metadata.xml";
        return ((CompletableFuture)this.storage.exists((Key)new Key.From(artifact, new String[]{"maven-metadata.xml"})).thenCompose(exists -> {
            CompletionStage<Boolean> res = exists != false ? metadata.groupAndArtifact((Key)new Key.From(upload, new String[]{"meta"})).thenCompose(existing -> metadata.groupAndArtifact(artifact).thenApply(uploaded -> uploaded.equals(existing))) : CompletableFuture.completedStage(true);
            return res;
        })).thenCompose(same -> {
            CompletionStage res = same != false ? (CompletionStage)this.validateArtifactChecksums((Key)new Key.From(upload, new String[]{"maven-metadata.xml"})).to(SingleInterop.get()) : CompletableFuture.completedStage(false);
            return res;
        });
    }

    private CompletionStage<Boolean> validateChecksums(Key upload) {
        return (CompletionStage)new RxStorageWrapper(this.storage).list(upload).flatMapObservable(Observable::fromIterable).filter(key -> PTN_ARTIFACT.matcher(key.string()).matches()).flatMapSingle(this::validateArtifactChecksums).reduce(new ArrayList(5), (list, res) -> {
            list.add(res);
            return list;
        }).map(array -> !array.isEmpty() && !array.contains(false)).to(SingleInterop.get());
    }

    private Single<Boolean> validateArtifactChecksums(Key artifact) {
        return SingleInterop.fromFuture(new RepositoryChecksums(this.storage).checksums(artifact)).map(Map::entrySet).flatMapObservable(Observable::fromIterable).flatMapSingle(entry -> SingleInterop.fromFuture((CompletionStage)this.storage.value(artifact).thenCompose(content -> new ContentDigest(content, (Supplier)Digests.valueOf((String)((String)entry.getKey()).toUpperCase(Locale.US))).hex().thenApply(hex -> hex.equals(entry.getValue()))))).all(equal -> equal);
    }
}

