/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Key;
import com.artipie.asto.ext.KeyLastPart;
import com.artipie.http.Headers;
import com.artipie.http.headers.Header;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jetty.http.MimeTypes;

final class ArtifactHeaders
extends Headers.Wrap {
    ArtifactHeaders(Key location, Map<String, String> checksums) {
        super((Iterable)new Headers.From((Iterable)ArtifactHeaders.checksumsHeader(checksums), new Map.Entry[]{ArtifactHeaders.contentDisposition(location), ArtifactHeaders.contentType(location)}));
    }

    private static Header contentDisposition(Key location) {
        return new Header("Content-Disposition", String.format("attachment; filename=\"%s\"", new KeyLastPart(location).get()));
    }

    private static Headers checksumsHeader(Map<String, String> checksums) {
        ArrayList<Header> headers = new ArrayList<Header>(checksums.size() + 1);
        for (Map.Entry<String, String> entry : checksums.entrySet()) {
            headers.add(new Header(String.format("X-Checksum-%s", entry.getKey()), entry.getValue()));
        }
        Optional.ofNullable(checksums.get("sha1")).ifPresent(sha -> headers.add(new Header("ETag", sha)));
        return new Headers.From(headers);
    }

    private static Header contentType(Key key) {
        String src = key.string();
        return new Header("Content-Type", Optional.ofNullable(switch (ArtifactHeaders.extension(key)) {
            case "jar" -> "application/java-archive";
            case "pom" -> "application/x-maven-pom+xml";
            default -> MimeTypes.getDefaultMimeByExtension((String)src);
        }).orElse("*"));
    }

    private static String extension(Key key) {
        String src = key.string();
        return src.substring(src.lastIndexOf(46) + 1).toLowerCase(Locale.US);
    }
}

