/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.slice.KeyFromPath;
import com.artipie.maven.http.UploadSlice;
import com.artipie.maven.metadata.DeployMetadata;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

public final class PutMetadataSlice
implements Slice {
    public static final String SUB_META = "meta";
    static final Pattern PTN_META = Pattern.compile("^/(?<pkg>.+)/maven-metadata.xml$");
    private static final String MAVEN_METADATA = "maven-metadata.xml";
    private final Storage asto;

    public PutMetadataSlice(Storage asto) {
        this.asto = asto;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus res;
        Matcher matcher = PTN_META.matcher(new RequestLineFrom(line).uri().getPath());
        if (matcher.matches()) {
            KeyFromPath pkg = new KeyFromPath(matcher.group("pkg"));
            res = new AsyncResponse(new PublisherAs(body).asciiString().thenCombine(this.asto.list((Key)new Key.From(UploadSlice.TEMP, (Key)pkg)), (arg_0, arg_1) -> this.lambda$response$2((Key)pkg, arg_0, arg_1)).thenApply(nothing -> new RsWithStatus(RsStatus.CREATED)));
        } else {
            res = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return res;
    }

    private /* synthetic */ CompletableFuture lambda$response$2(Key pkg, String xml, Collection list) {
        Optional<String> snapshot = new DeployMetadata(xml).snapshots().stream().filter(item -> list.stream().anyMatch(key -> key.string().contains((CharSequence)item))).findFirst();
        Key.From key = snapshot.isPresent() ? new Key.From(UploadSlice.TEMP, new String[]{pkg.string(), snapshot.get(), SUB_META, MAVEN_METADATA}) : new Key.From(UploadSlice.TEMP, new String[]{pkg.string(), new DeployMetadata(xml).release(), SUB_META, MAVEN_METADATA});
        return this.asto.save((Key)key, (Content)new Content.From(xml.getBytes(StandardCharsets.US_ASCII)));
    }
}

