/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.maven.metadata;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.maven.metadata.Version;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Comparator;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.xembly.Directive;
import org.xembly.Directives;
import org.xembly.Xembler;

public final class MavenMetadata {
    private final Directives dirs;

    public MavenMetadata(Iterable<Directive> source) {
        this.dirs = new Directives(source);
    }

    public MavenMetadata versions(Set<String> items) {
        Directives copy = new Directives((Iterable)this.dirs);
        copy.xpath((Object)"/metadata").push().xpath((Object)"versioning").remove().pop().xpath((Object)"/metadata").add((Object)"versioning");
        items.stream().max(Comparator.comparing(Version::new)).ifPresent(latest -> copy.add((Object)"latest").set(latest).up());
        items.stream().filter(version -> !version.endsWith("SNAPSHOT")).max(Comparator.comparing(Version::new)).ifPresent(latest -> copy.add((Object)"release").set(latest).up());
        copy.add((Object)"versions");
        items.forEach(version -> copy.add((Object)"version").set(version).up());
        copy.up();
        copy.addIf((Object)"lastUpdated").set((Object)Instant.now().toEpochMilli()).up();
        copy.up();
        return new MavenMetadata((Iterable<Directive>)copy);
    }

    public CompletionStage<Key> save(Storage storage, Key base) {
        Key.From res = new Key.From(base, new String[]{"maven-metadata.xml"});
        return ((CompletableFuture)CompletableFuture.supplyAsync(() -> new Xembler((Iterable)this.dirs).xmlQuietly().getBytes(StandardCharsets.UTF_8)).thenCompose(arg_0 -> MavenMetadata.lambda$save$5(storage, (Key)res, arg_0))).thenApply(arg_0 -> MavenMetadata.lambda$save$6((Key)res, arg_0));
    }

    private static /* synthetic */ Key lambda$save$6(Key res, Void nothing) {
        return res;
    }

    private static /* synthetic */ CompletionStage lambda$save$5(Storage storage, Key res, byte[] data) {
        return storage.save(res, (Content)new Content.From(data));
    }
}

