/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import com.artipie.npm.TgzRelativePath;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

final class Meta {
    private final JsonObject json;
    private final Optional<String> pathpref;

    Meta(JsonObject json, Optional<String> pathpref) {
        this.json = json;
        this.pathpref = pathpref;
    }

    public Meta updatedMeta(JsonObject uploaded) {
        JsonObject versions = uploaded.getJsonObject("versions");
        Set keys = versions.keySet();
        JsonPatchBuilder patch = Json.createPatchBuilder();
        if (!this.json.containsKey((Object)"dist-tags")) {
            patch.add("/dist-tags", (JsonValue)Json.createObjectBuilder().build());
        }
        for (Map.Entry tag : uploaded.getJsonObject("dist-tags").entrySet()) {
            patch.add(String.format("/dist-tags/%s", tag.getKey()), (JsonValue)tag.getValue());
        }
        for (String key : keys) {
            JsonObject version = versions.getJsonObject(key);
            patch.add(String.format("/versions/%s", key), (JsonValue)version);
            this.pathpref.ifPresent(prefix -> patch.add(String.format("/versions/%s/dist/tarball", key), String.format("%s%s", prefix, new TgzRelativePath(version.getJsonObject("dist").getString("tarball")).relative())));
        }
        return new Meta((JsonObject)patch.build().apply((JsonStructure)this.json), this.pathpref);
    }

    public Flowable<ByteBuffer> byteFlow() {
        return Flowable.fromArray((Object[])new ByteBuffer[]{ByteBuffer.wrap(this.json.toString().getBytes(StandardCharsets.UTF_8))});
    }
}

