/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.npm.Meta;
import com.artipie.npm.NpmPublishJsonToMetaSkelethon;
import com.artipie.npm.TgzArchive;
import hu.akarnokd.rxjava2.interop.CompletableInterop;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonObject;
import org.reactivestreams.Publisher;

public class Npm {
    private final RxStorage storage;
    private final Optional<String> pathpref;

    public Npm(Storage storage) {
        this(storage, Optional.empty());
    }

    public Npm(Storage storage, Optional<String> pathpref) {
        this.storage = new RxStorageWrapper(storage);
        this.pathpref = pathpref;
    }

    public final CompletableFuture<Void> publish(Key prefix, Key artifact) {
        return ((CompletionStage)this.storage.value(artifact).flatMapPublisher(bytes -> bytes).toList().map(bytes -> Json.createReader((InputStream)new ByteArrayInputStream(Npm.bytesFromListOfByteBuffers(bytes))).readObject()).flatMapCompletable(uploaded -> this.updateMetaFile(prefix, (JsonObject)uploaded).andThen((CompletableSource)this.updateSourceArchives(prefix, (JsonObject)uploaded))).to(CompletableInterop.await())).thenApply(r -> null).toCompletableFuture();
    }

    public Completable updateMetaFile(Key prefix, TgzArchive file) {
        throw new UnsupportedOperationException();
    }

    private Completable updateSourceArchives(Key prefix, JsonObject uploaded) {
        return Single.fromCallable(() -> uploaded.getJsonObject("_attachments")).flatMapCompletable(attachments -> Completable.concat((Iterable)attachments.keySet().stream().map(attachment -> {
            byte[] bytes = new TgzArchive(attachments.getJsonObject(attachment).getString("data")).bytes();
            return this.storage.save((Key)new Key.From(prefix, new String[]{attachment}), (Content)new Content.From((Publisher)Flowable.fromArray((Object[])new ByteBuffer[]{ByteBuffer.wrap(bytes)})));
        }).collect(Collectors.toList())));
    }

    private Completable updateMetaFile(Key prefix, JsonObject uploaded) {
        Key.From metafilename = new Key.From(prefix, new String[]{"meta.json"});
        return this.storage.exists((Key)metafilename).flatMap(arg_0 -> this.lambda$updateMetaFile$9((Key)metafilename, uploaded, arg_0)).map(meta -> meta.updatedMeta(uploaded)).flatMapCompletable(arg_0 -> this.lambda$updateMetaFile$11((Key)metafilename, arg_0));
    }

    private static byte[] bytesFromListOfByteBuffers(List<ByteBuffer> buffers) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        buffers.forEach(buffer -> {
            try {
                output.write(new Remaining(buffer).bytes());
            }
            catch (IOException exp) {
                throw new UncheckedIOException(exp);
            }
        });
        return output.toByteArray();
    }

    private /* synthetic */ CompletableSource lambda$updateMetaFile$11(Key metafilename, Meta meta) throws Exception {
        return this.storage.save(metafilename, (Content)new Content.From(meta.byteFlow()));
    }

    private /* synthetic */ SingleSource lambda$updateMetaFile$9(Key metafilename, JsonObject uploaded, Boolean exists) throws Exception {
        Single meta = exists != false ? this.storage.value(metafilename).flatMapPublisher(bytes -> bytes).toList().map(bytes -> new Meta(Json.createReader((InputStream)new ByteArrayInputStream(Npm.bytesFromListOfByteBuffers(bytes))).readObject(), this.pathpref)) : Single.just((Object)new Meta(new NpmPublishJsonToMetaSkelethon(uploaded).skeleton(), this.pathpref));
        return meta;
    }
}

