/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.Identities;
import com.artipie.http.auth.Permission;
import com.artipie.http.auth.Permissions;
import com.artipie.http.auth.SliceAuth;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rt.RtRule;
import com.artipie.http.rt.SliceRoute;
import com.artipie.http.slice.SliceDownload;
import com.artipie.npm.Npm;
import com.artipie.npm.http.DownloadPackageSlice;
import com.artipie.npm.http.ReplacePathSlice;
import com.artipie.npm.http.UploadSlice;
import java.nio.ByteBuffer;
import java.util.Map;
import org.reactivestreams.Publisher;

public final class NpmSlice
implements Slice {
    private static final String PERM_DOWNLOAD = "download";
    private static final String PERM_UPLOAD = "upload";
    private final SliceRoute route;

    public NpmSlice(Storage storage) {
        this(new Npm(storage), storage);
    }

    public NpmSlice(Npm npm, Storage storage) {
        this("/", npm, storage);
    }

    public NpmSlice(String path, Npm npm, Storage storage) {
        this(path, npm, storage, Permissions.FREE, Identities.ANONYMOUS);
    }

    public NpmSlice(String path, Npm npm, Storage storage, Permissions perms, Identities users) {
        this.route = new SliceRoute(new SliceRoute.Path[]{new SliceRoute.Path((RtRule)new RtRule.ByMethod(RqMethod.PUT), (Slice)new SliceAuth((Slice)new UploadSlice(path, npm, storage), (Permission)new Permission.ByName(PERM_UPLOAD, perms), users)), new SliceRoute.Path((RtRule)new RtRule.Multiple(new RtRule[]{new RtRule.ByMethod(RqMethod.GET), new RtRule.ByPath(".*(?<!\\.tgz)$")}), (Slice)new SliceAuth((Slice)new DownloadPackageSlice(path, storage), (Permission)new Permission.ByName(PERM_DOWNLOAD, perms), users)), new SliceRoute.Path((RtRule)new RtRule.Multiple(new RtRule[]{new RtRule.ByMethod(RqMethod.GET), new RtRule.ByPath(".*\\.tgz$")}), (Slice)new SliceAuth((Slice)new ReplacePathSlice(path, (Slice)new SliceDownload(storage)), (Permission)new Permission.ByName(PERM_DOWNLOAD, perms), users))});
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.route.response(line, headers, body);
    }
}

