/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TgzRelativePath {
    private final String full;

    public TgzRelativePath(String full) {
        this.full = full;
    }

    public String relative() {
        String result;
        Optional<String> npms = this.npmWithScope();
        Optional<String> npmws = this.npmWithoutScope();
        Optional<String> curls = this.curlWithScope();
        Optional<String> curlws = this.curlWithoutScope();
        if (npms.isPresent()) {
            result = npms.get();
        } else if (npmws.isPresent()) {
            result = npmws.get();
        } else if (curls.isPresent()) {
            result = curls.get();
        } else if (curlws.isPresent()) {
            result = curlws.get();
        } else {
            throw new IllegalStateException("a relative path was not found");
        }
        return result;
    }

    private Optional<String> npmWithScope() {
        return this.firstGroup(Pattern.compile("(@[\\w-_]+/[\\w_-]+/-/@[\\w-_]+/[\\w.-]+.tgz)"));
    }

    private Optional<String> npmWithoutScope() {
        return this.firstGroup(Pattern.compile("([\\w_-]+/-/[\\w.-]+.tgz)"));
    }

    private Optional<String> curlWithScope() {
        return this.firstGroup(Pattern.compile("(@[\\w-_]+/[\\w-_]+/[\\w.-]+.tgz)"));
    }

    private Optional<String> curlWithoutScope() {
        return this.firstGroup(Pattern.compile("([\\w-_]+/[\\w.-]+\\.tgz)"));
    }

    private Optional<String> firstGroup(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.full);
        boolean found = matcher.find();
        Optional<String> result = found ? Optional.of(matcher.group(1)) : Optional.empty();
        return result;
    }
}

