/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.amihaiemil.eoyaml.YamlMapping;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public final class NpmProxyConfig {
    public static final int METADATA_TTL_MIN = 1440;
    private static final int CONNECT_TIMEOUT = 2000;
    private static final int REQUEST_TIMEOUT = 5000;
    private final YamlMapping yaml;

    public NpmProxyConfig(YamlMapping yaml) {
        this.yaml = yaml;
    }

    public String url() {
        return this.remoteSettings().string("url");
    }

    public int requestTimeout() {
        return NpmProxyConfig.intOrDefault(this.remoteSettings().string("request-timeout"), 5000);
    }

    public int connectTimeout() {
        return NpmProxyConfig.intOrDefault(this.remoteSettings().string("connect-timeout"), 2000);
    }

    public Duration metadataTtl() {
        int ttl = NpmProxyConfig.intOrDefault(this.yaml.string("metadata-ttl-minutes"), 1440);
        return Duration.of(ttl, ChronoUnit.MINUTES);
    }

    private YamlMapping remoteSettings() {
        return Objects.requireNonNull(this.yaml.yamlMapping("remote"));
    }

    private static int intOrDefault(String param, int defaultValue) {
        int result = StringUtils.isEmpty((CharSequence)param) ? defaultValue : Integer.parseInt(param);
        return result;
    }
}

