/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy.model;

import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import org.reactivestreams.Publisher;

public final class NpmAsset {
    private final String path;
    private final Publisher<ByteBuffer> content;
    private final Metadata metadata;

    public NpmAsset(String path, Publisher<ByteBuffer> content, String modified, String ctype) {
        this(path, content, new Metadata(modified, ctype));
    }

    public NpmAsset(String path, Publisher<ByteBuffer> content, Metadata metadata) {
        this.path = path;
        this.content = content;
        this.metadata = metadata;
    }

    public String path() {
        return this.path;
    }

    public Publisher<ByteBuffer> dataPublisher() {
        return this.content;
    }

    public Metadata meta() {
        return this.metadata;
    }

    public static class Metadata {
        private final String modified;
        private final String ctype;

        public Metadata(JsonObject json) {
            this(json.getString("last-modified"), json.getString("content-type"));
        }

        Metadata(String modified, String ctype) {
            this.modified = modified;
            this.ctype = ctype;
        }

        public String lastModified() {
            return this.modified;
        }

        public String contentType() {
            return this.ctype;
        }

        public JsonObject json() {
            JsonObject json = new JsonObject();
            json.put("last-modified", this.modified);
            json.put("content-type", this.ctype);
            return json;
        }
    }
}

