/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy.model;

import io.vertx.core.json.JsonObject;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;

public final class NpmPackage {
    private final String name;
    private final String content;
    private final Metadata metadata;

    public NpmPackage(String name, String content, String modified, OffsetDateTime refreshed) {
        this(name, content, new Metadata(modified, refreshed));
    }

    public NpmPackage(String name, String content, Metadata metadata) {
        this.name = name;
        this.content = content;
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public String content() {
        return this.content;
    }

    public Metadata meta() {
        return this.metadata;
    }

    public static class Metadata {
        private final String modified;
        private final OffsetDateTime refreshed;

        public Metadata(JsonObject json) {
            this(json.getString("last-modified"), OffsetDateTime.parse(json.getString("last-refreshed"), DateTimeFormatter.ISO_OFFSET_DATE_TIME));
        }

        Metadata(String modified, OffsetDateTime refreshed) {
            this.modified = modified;
            this.refreshed = refreshed;
        }

        public String lastModified() {
            return this.modified;
        }

        public OffsetDateTime lastRefreshed() {
            return this.refreshed;
        }

        public JsonObject json() {
            JsonObject json = new JsonObject();
            json.put("last-modified", this.modified);
            json.put("last-refreshed", DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.refreshed));
            return json;
        }
    }
}

