/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Remaining;
import io.reactivex.Completable;
import io.reactivex.Single;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Base64;
import javax.json.Json;
import javax.json.JsonObject;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;

public final class TgzArchive {
    private final String bitstring;
    private final boolean encoded;

    public TgzArchive(String bitstring) {
        this(bitstring, true);
    }

    public TgzArchive(String bitstring, boolean encoded) {
        this.bitstring = bitstring;
        this.encoded = encoded;
    }

    public Completable saveToFile(Path path) {
        return Completable.fromAction(() -> Files.write(path, this.bytes(), new OpenOption[0]));
    }

    public byte[] bytes() {
        byte[] res = this.encoded ? Base64.getDecoder().decode(this.bitstring) : this.bitstring.getBytes(StandardCharsets.ISO_8859_1);
        return res;
    }

    public Single<JsonObject> packageJson() {
        return this.file("package.json").map(Concatenation::new).flatMap(Concatenation::single).map(Remaining::new).map(Remaining::bytes).map(bytes -> Json.createReader((Reader)new StringReader(new String((byte[])bytes))).readObject());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Single<Content> file(String name) {
        try (ByteArrayInputStream bytearr = new ByteArrayInputStream(this.bytes());
             GzipCompressorInputStream gzip = new GzipCompressorInputStream((InputStream)bytearr);
             TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)gzip);){
            TarArchiveEntry entry;
            while ((entry = tar.getNextTarEntry()) != null) {
                String[] parts = entry.getName().split("/");
                if (!parts[parts.length - 1].equals(name)) continue;
                Single single = Single.just((Object)new Content.From(IOUtils.toByteArray((InputStream)tar)));
                return single;
            }
            throw new IllegalStateException(String.format("'%s' file was not found", name));
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }
}

