/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TgzRelativePath {
    private static final Pattern VRSN = Pattern.compile(".*(\\d+.\\d+.\\d+[-.\\w]*).tgz");
    private final String full;

    public TgzRelativePath(String full) {
        this.full = full;
    }

    public String relative() {
        return this.relative(false);
    }

    public String relative(boolean replace) {
        String res;
        Matched matched = this.matchedValues();
        if (replace) {
            Matcher matcher = VRSN.matcher(matched.name());
            if (!matcher.matches()) {
                throw new IllegalStateException(String.format("Failed to replace `/-/` in path `%s` with name `%s`", matched.group(), matched.name()));
            }
            res = matched.group().replace("/-/", String.format("/%s/", matcher.group(1)));
        } else {
            res = matched.group();
        }
        return res;
    }

    private Matched matchedValues() {
        Matched matched;
        Optional<Matched> npms = this.npmWithScope();
        Optional<Matched> npmws = this.npmWithoutScope();
        Optional<Matched> curls = this.curlWithScope();
        Optional<Matched> curlws = this.curlWithoutScope();
        if (npms.isPresent()) {
            matched = npms.get();
        } else if (curls.isPresent()) {
            matched = curls.get();
        } else if (npmws.isPresent()) {
            matched = npmws.get();
        } else if (curlws.isPresent()) {
            matched = curlws.get();
        } else {
            throw new IllegalStateException("a relative path was not found");
        }
        return matched;
    }

    private Optional<Matched> npmWithScope() {
        return this.matches(Pattern.compile("(@[\\w-]+/[\\w.-]+/-/@[\\w-]+/(?<name>[\\w.-]+.tgz)$)"));
    }

    private Optional<Matched> npmWithoutScope() {
        return this.matches(Pattern.compile("([\\w.-]+/-/(?<name>[\\w.-]+.tgz)$)"));
    }

    private Optional<Matched> curlWithScope() {
        return this.matches(Pattern.compile("(@[\\w-]+/[\\w.-]+/(?<name>(@?(?<!-/@)[\\w.-]+/)*[\\w.-]+.tgz)$)"));
    }

    private Optional<Matched> curlWithoutScope() {
        return this.matches(Pattern.compile("([\\w.-]+(/\\d+.\\d+.\\d+[\\w.-]*)?/(?<name>[\\w.-]+\\.tgz)$)"));
    }

    private Optional<Matched> matches(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.full);
        boolean found = matcher.find();
        Optional<Matched> result = found ? Optional.of(new Matched(matcher.group(1), matcher.group("name"))) : Optional.empty();
        return result;
    }

    private static final class Matched {
        private final String fgroup;
        private final String cname;

        Matched(String fgroup, String name) {
            this.fgroup = fgroup;
            this.cname = name;
        }

        public String name() {
            return this.cname;
        }

        public String group() {
            return this.fgroup;
        }
    }
}

