/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.npm.MetaUpdate;
import com.artipie.npm.Publish;
import com.artipie.npm.TgzArchive;
import com.artipie.npm.misc.JsonFromPublisher;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Pattern;
import javax.json.JsonObject;

final class CliPublish
implements Publish {
    public static final Pattern HEADER = Pattern.compile("publish.*");
    private final Storage storage;

    CliPublish(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletableFuture<Void> publish(Key prefix, Key artifact) {
        return ((CompletableFuture)((CompletableFuture)this.storage.value(artifact).thenApply(JsonFromPublisher::new)).thenCompose(JsonFromPublisher::json)).thenCompose(uploaded -> CompletableFuture.allOf(new MetaUpdate.ByJson((JsonObject)uploaded).update(prefix, this.storage), this.updateSourceArchives((JsonObject)uploaded)));
    }

    private CompletableFuture<Void> updateSourceArchives(JsonObject uploaded) {
        return CompletableFuture.supplyAsync(() -> uploaded.getJsonObject("_attachments")).thenCompose(attach -> CompletableFuture.allOf((CompletableFuture[])attach.keySet().stream().map(attachment -> {
            byte[] bytes = new TgzArchive(attach.getJsonObject(attachment).getString("data")).bytes();
            return this.storage.save((Key)new Key.From(new String[]{uploaded.getString("name"), "-", attachment}), (Content)new Content.From(bytes));
        }).toArray(CompletableFuture[]::new)));
    }
}

