/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.StandardRs;
import com.artipie.npm.PackageNameFromUrl;
import com.artipie.npm.misc.DateTimeNowStr;
import com.artipie.npm.misc.DescSortedVersions;
import com.artipie.npm.misc.JsonFromPublisher;
import com.google.common.collect.Sets;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import org.reactivestreams.Publisher;

final class UnpublishPutSlice
implements Slice {
    public static final Pattern HEADER = Pattern.compile("unpublish.*");
    private final Storage asto;

    UnpublishPutSlice(Storage storage) {
        this.asto = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> publisher) {
        String pkg = new PackageNameFromUrl(line.replaceFirst("/-rev/[^\\s]+", "")).value();
        Key.From key = new Key.From(new String[]{pkg, "meta.json"});
        return new AsyncResponse(this.asto.exists((Key)key).thenCompose(arg_0 -> this.lambda$response$2(publisher, (Key)key, arg_0)));
    }

    private static String updateMeta(JsonObject update, JsonObject source) {
        JsonPatchBuilder patch = Json.createPatchBuilder();
        String diff = UnpublishPutSlice.versionToRemove(update, source);
        patch.remove(String.format("/versions/%s", diff));
        patch.remove(String.format("/time/%s", diff));
        if (source.getJsonObject("dist-tags").containsKey((Object)diff)) {
            patch.remove(String.format("/dist-tags/%s", diff));
        }
        String latest = new DescSortedVersions(update.getJsonObject("versions")).value().get(0);
        patch.add("/dist-tags/latest", latest);
        patch.add("/time/modified", new DateTimeNowStr().value());
        return ((JsonObject)patch.build().apply((JsonStructure)source)).toString();
    }

    private static String versionToRemove(JsonObject update, JsonObject source) {
        String field = "versions";
        Sets.SetView diff = Sets.symmetricDifference((Set)source.getJsonObject("versions").keySet(), (Set)update.getJsonObject("versions").keySet());
        if (diff.size() != 1) {
            throw new IllegalStateException(String.format("Failed to unpublish single version. Should be one version, but were `%s`", diff.toString()));
        }
        return (String)diff.iterator().next();
    }

    private /* synthetic */ CompletionStage lambda$response$2(Publisher publisher, Key key, Boolean exists) {
        CompletionStage<Object> res = exists != false ? ((CompletableFuture)((CompletableFuture)new JsonFromPublisher((Publisher<ByteBuffer>)publisher).json().thenCombine(((CompletableFuture)this.asto.value(key).thenApply(JsonFromPublisher::new)).thenCompose(JsonFromPublisher::json), UnpublishPutSlice::updateMeta)).thenCompose(meta -> this.asto.save(key, (Content)new Content.From(meta.getBytes(StandardCharsets.UTF_8))))).thenApply(nothing -> StandardRs.OK) : CompletableFuture.completedFuture(StandardRs.NOT_FOUND);
        return res;
    }
}

