/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy.http;

import com.artipie.asto.Content;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithBody;
import com.artipie.http.rs.RsWithHeaders;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.npm.proxy.NpmProxy;
import com.artipie.npm.proxy.http.PackagePath;
import com.artipie.npm.proxy.http.RsNotFound;
import com.artipie.npm.proxy.json.ClientContent;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.cactoos.list.ListOf;
import org.cactoos.map.MapEntry;
import org.reactivestreams.Publisher;

public final class DownloadPackageSlice
implements Slice {
    private final NpmProxy npm;
    private final PackagePath path;

    public DownloadPackageSlice(NpmProxy npm, PackagePath path) {
        this.npm = npm;
        this.path = path;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return new AsyncResponse((CompletionStage)this.npm.getPackage(this.path.value(new RequestLineFrom(line).uri().getPath())).map(pkg -> new RsWithHeaders((Response)new RsWithBody((Response)new RsWithStatus(RsStatus.OK), (Content)new Content.From(this.clientFormat(pkg.content(), headers).getBytes())), (Iterable)new ListOf((Object[])new Map.Entry[]{new MapEntry((Object)"Content-Type", (Object)"application/json"), new MapEntry((Object)"Last-Modified", (Object)pkg.meta().lastModified())}))).toSingle((Object)new RsNotFound()).to(SingleInterop.get()));
    }

    private String clientFormat(String data, Iterable<Map.Entry<String, String>> headers) {
        String host = (String)StreamSupport.stream(headers.spliterator(), false).filter(e -> ((String)e.getKey()).equalsIgnoreCase("Host")).findAny().orElseThrow(() -> new RuntimeException("Could not find Host header in request")).getValue();
        return new ClientContent(data, this.assetPrefix(host)).value();
    }

    private String assetPrefix(String host) {
        String result = StringUtils.isEmpty((CharSequence)this.path.prefix()) ? String.format("http://%s", host) : String.format("http://%s/%s", host, this.path.prefix());
        return result;
    }
}

