/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rq.RequestLineFrom;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rs.StandardRs;
import com.artipie.npm.PackageNameFromUrl;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.reactivestreams.Publisher;

final class UnpublishForceSlice
implements Slice {
    static final Pattern PTRN = Pattern.compile("/.*/-rev/.*$");
    private final Storage storage;

    UnpublishForceSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        RsWithStatus resp;
        RequestLineFrom rqline = new RequestLineFrom(line);
        String uri = rqline.uri().getPath();
        Matcher matcher = PTRN.matcher(uri);
        if (matcher.matches()) {
            String pkg = new PackageNameFromUrl(String.format("%s %s %s", rqline.method(), uri.substring(0, uri.indexOf("/-rev/")), rqline.version())).value();
            resp = new AsyncResponse(this.storage.list((Key)new Key.From(pkg)).thenCompose(keys -> CompletableFuture.allOf((CompletableFuture[])keys.stream().map(arg_0 -> ((Storage)this.storage).delete(arg_0)).toArray(CompletableFuture[]::new)).thenApply(nothing -> StandardRs.OK)));
        } else {
            resp = new RsWithStatus(RsStatus.BAD_REQUEST);
        }
        return resp;
    }
}

