/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.npm.proxy.NpmRemote;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import io.reactivex.Maybe;
import io.vertx.circuitbreaker.CircuitBreaker;
import java.io.IOException;
import java.nio.file.Path;

public final class CircuitBreakerNpmRemote
implements NpmRemote {
    private final NpmRemote wrapped;
    private final CircuitBreaker breaker;

    public CircuitBreakerNpmRemote(NpmRemote wrapped, CircuitBreaker breaker) {
        this.wrapped = wrapped;
        this.breaker = breaker;
    }

    @Override
    public void close() throws IOException {
        this.wrapped.close();
        this.breaker.close();
    }

    @Override
    public Maybe<NpmPackage> loadPackage(String name) {
        return Maybe.fromFuture(this.breaker.executeWithFallback(future -> future.complete(this.wrapped.loadPackage(name)), exception -> Maybe.empty()).toCompletionStage().toCompletableFuture()).flatMap(m -> m);
    }

    @Override
    public Maybe<NpmAsset> loadAsset(String path, Path tmp) {
        return Maybe.fromFuture(this.breaker.executeWithFallback(future -> future.complete(this.wrapped.loadAsset(path, tmp)), exception -> Maybe.empty()).toCompletionStage().toCompletableFuture()).flatMap(m -> m);
    }
}

