/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Remaining;
import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.npm.MetaUpdate;
import com.artipie.npm.Publish;
import com.artipie.npm.TgzArchive;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;

final class CurlPublish
implements Publish {
    static final Pattern PTRN = Pattern.compile(".*\\.tgz");
    private final Storage storage;

    CurlPublish(Storage storage) {
        this.storage = storage;
    }

    @Override
    public CompletableFuture<Void> publish(Key prefix, Key artifact) {
        return ((CompletionStage)new RxStorageWrapper(this.storage).value(artifact).map(Concatenation::new).flatMap(Concatenation::single).map(Remaining::new).map(Remaining::bytes).map(bytes -> new String((byte[])bytes, StandardCharsets.ISO_8859_1)).map(bytes -> new TgzArchive((String)bytes, false)).to(SingleInterop.get())).toCompletableFuture().thenCompose(uploaded -> ((CompletionStage)uploaded.packageJson().to(SingleInterop.get())).thenCompose(pkg -> {
            String name = pkg.getString("name");
            String vers = pkg.getString("version");
            return CompletableFuture.allOf(this.storage.save((Key)new Key.From(new String[]{name, "-", String.format("%s-%s.tgz", name, vers)}), (Content)new Content.From(uploaded.bytes())), new MetaUpdate.ByTgz((TgzArchive)uploaded).update((Key)new Key.From(name), this.storage));
        }));
    }
}

