/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.async.AsyncResponse;
import com.artipie.http.rs.StandardRs;
import com.artipie.npm.PackageNameFromUrl;
import com.artipie.npm.misc.JsonFromPublisher;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import org.apache.commons.lang3.StringUtils;
import org.reactivestreams.Publisher;

public final class DeprecateSlice
implements Slice {
    static final Pattern HEADER = Pattern.compile("deprecate.*");
    private final Storage storage;

    public DeprecateSlice(Storage storage) {
        this.storage = storage;
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> iterable, Publisher<ByteBuffer> publisher) {
        String pkg = new PackageNameFromUrl(line).value();
        Key.From key = new Key.From(new String[]{pkg, "meta.json"});
        return new AsyncResponse(this.storage.exists((Key)key).thenCompose(arg_0 -> this.lambda$response$4(publisher, (Key)key, arg_0)));
    }

    private static JsonObject deprecate(JsonObject versions, JsonObject meta) {
        JsonPatchBuilder res = Json.createPatchBuilder();
        String field = "deprecated";
        String path = "/versions/%s/deprecated";
        for (String version : versions.keySet()) {
            if (!versions.getJsonObject(version).containsKey((Object)"deprecated")) continue;
            if (StringUtils.isEmpty((CharSequence)versions.getJsonObject(version).getString("deprecated"))) {
                res.remove(String.format("/versions/%s/deprecated", version));
                continue;
            }
            res.add(String.format("/versions/%s/deprecated", version), versions.getJsonObject(version).getString("deprecated"));
        }
        return (JsonObject)res.build().apply((JsonStructure)meta);
    }

    private /* synthetic */ CompletionStage lambda$response$4(Publisher publisher, Key key, Boolean exists) {
        CompletionStage<Object> res = exists != false ? ((CompletableFuture)((CompletableFuture)((CompletableFuture)new JsonFromPublisher((Publisher<ByteBuffer>)publisher).json().thenApply(json -> json.getJsonObject("versions"))).thenCombine(((CompletableFuture)this.storage.value(key).thenApply(JsonFromPublisher::new)).thenCompose(JsonFromPublisher::json), (body, meta) -> DeprecateSlice.deprecate(body, meta).toString())).thenCompose(str -> this.storage.save(key, (Content)new Content.From(str.getBytes(StandardCharsets.UTF_8))))).thenApply(nothing -> StandardRs.OK) : CompletableFuture.completedFuture(StandardRs.NOT_FOUND);
        return res;
    }
}

