/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.misc;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.ServerSocket;

public class NextSafeAvailablePort {
    private static final int MIN_PORT = 1024;
    private static final int MAX_PORT = 49151;
    private final int from;

    public NextSafeAvailablePort() {
        this(1024);
    }

    public NextSafeAvailablePort(int from) {
        this.from = from;
    }

    public int value() {
        if (this.from < 1024 || this.from > 49151) {
            throw new IllegalArgumentException(String.format("Invalid start port: %d", this.from));
        }
        for (int port = this.from; port <= 49151; ++port) {
            if (!NextSafeAvailablePort.available(port)) continue;
            return port;
        }
        throw new IllegalArgumentException(String.format("Could not find an available port above %d", this.from));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean available(int port) {
        ServerSocket sersock = null;
        DatagramSocket dgrmsock = null;
        try {
            sersock = new ServerSocket(port);
            sersock.setReuseAddress(true);
            dgrmsock = new DatagramSocket(port);
            dgrmsock.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
        }
        finally {
            if (dgrmsock != null) {
                dgrmsock.close();
            }
            if (sersock != null) {
                try {
                    sersock.close();
                }
                catch (IOException iOException) {}
            }
        }
        return false;
    }
}

