/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.asto.Content;
import com.artipie.asto.ext.PublisherAs;
import com.artipie.http.ArtipieHttpException;
import com.artipie.http.Headers;
import com.artipie.http.Slice;
import com.artipie.http.rq.RequestLine;
import com.artipie.http.rq.RqHeaders;
import com.artipie.http.rq.RqMethod;
import com.artipie.npm.misc.DateTimeNowStr;
import com.artipie.npm.proxy.NpmRemote;
import com.artipie.npm.proxy.json.CachedContent;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import com.jcabi.log.Logger;
import io.reactivex.Flowable;
import io.reactivex.Maybe;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.time.OffsetDateTime;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.reactivestreams.Publisher;

public final class HttpNpmRemote
implements NpmRemote {
    private final Slice origin;

    public HttpNpmRemote(Slice origin) {
        this.origin = origin;
    }

    @Override
    public Maybe<NpmPackage> loadPackage(String name) {
        return Maybe.fromFuture(((CompletableFuture)this.performRemoteRequest(name).thenCompose(pair -> new PublisherAs((Content)pair.getKey()).asciiString().thenApply(str -> new NpmPackage(name, new CachedContent((String)str, name).value().toString(), HttpNpmRemote.lastModifiedOrNow((Headers)pair.getValue()), OffsetDateTime.now())))).toCompletableFuture()).onErrorResumeNext(throwable -> {
            Logger.error(HttpNpmRemote.class, (String)"Error occurred when process get package call: %s", (Object[])new Object[]{throwable.getMessage()});
            return Maybe.empty();
        });
    }

    @Override
    public Maybe<NpmAsset> loadAsset(String path, Path tmp) {
        return Maybe.fromFuture((Future)((Object)this.performRemoteRequest(path).thenApply(pair -> new NpmAsset(path, (Publisher<ByteBuffer>)((Publisher)pair.getKey()), HttpNpmRemote.lastModifiedOrNow((Headers)pair.getValue()), HttpNpmRemote.contentType((Headers)pair.getValue()))))).onErrorResumeNext(throwable -> {
            Logger.error(HttpNpmRemote.class, (String)"Error occurred when process get asset call: %s", (Object[])new Object[]{throwable.getMessage()});
            return Maybe.empty();
        });
    }

    @Override
    public void close() {
    }

    private CompletableFuture<Pair<Content, Headers>> performRemoteRequest(String name) {
        CompletableFuture<Pair<Content, Headers>> promise = new CompletableFuture<Pair<Content, Headers>>();
        this.origin.response(new RequestLine(RqMethod.GET, String.format("/%s", name)).toString(), (Iterable)Headers.EMPTY, (Publisher)Content.EMPTY).send((rsstatus, rsheaders, rsbody) -> {
            CompletableFuture term = new CompletableFuture();
            if (rsstatus.success()) {
                Flowable body = Flowable.fromPublisher((Publisher)rsbody).doOnError(term::completeExceptionally).doOnTerminate(() -> term.complete(null));
                promise.complete((Pair<Content, Headers>)new ImmutablePair((Object)new Content.From((Publisher)body), (Object)rsheaders));
            } else {
                promise.completeExceptionally((Throwable)new ArtipieHttpException(rsstatus));
            }
            return term;
        });
        return promise;
    }

    private static String lastModifiedOrNow(Headers hdrs) {
        RqHeaders hdr = new RqHeaders((Iterable)hdrs, "Last-Modified");
        String res = new DateTimeNowStr().value();
        if (!hdr.isEmpty()) {
            res = hdr.get(0);
        }
        return res;
    }

    private static String contentType(Headers hdrs) {
        RqHeaders hdr = new RqHeaders((Iterable)hdrs, "Content-Type");
        String res = "application/octet-stream";
        if (!hdr.isEmpty()) {
            res = hdr.get(0);
        }
        return res;
    }
}

