/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy.json;

import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public abstract class TransformedContent {
    private final String data;

    public TransformedContent(String data) {
        this.data = data;
    }

    public JsonObject value() {
        return this.transformAssetRefs();
    }

    abstract String transformRef(String var1);

    private JsonObject transformAssetRefs() {
        JsonObject json = Json.createReader((Reader)new StringReader(this.data)).readObject();
        JsonValue node = (JsonValue)json.get((Object)"versions");
        JsonPatchBuilder patch = Json.createPatchBuilder();
        if (node != null) {
            Set vrsns = node.asJsonObject().keySet();
            for (String vers : vrsns) {
                String path = String.format("/versions/%s/dist/tarball", vers);
                String asset = node.asJsonObject().getJsonObject(vers).getJsonObject("dist").getString("tarball");
                patch.replace(path, this.transformRef(asset));
            }
        }
        return (JsonObject)patch.build().apply((JsonStructure)json);
    }
}

