/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import com.artipie.npm.TgzRelativePath;
import com.artipie.npm.misc.DateTimeNowStr;
import io.reactivex.Flowable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;

final class Meta {
    static final String LATEST = "latest";
    private final JsonObject json;

    Meta(JsonObject json) {
        this.json = json;
    }

    public Meta updatedMeta(JsonObject uploaded) {
        boolean haslatest = false;
        JsonObject versions = uploaded.getJsonObject("versions");
        Set keys = versions.keySet();
        JsonPatchBuilder patch = Json.createPatchBuilder();
        if (this.json.containsKey((Object)"dist-tags")) {
            haslatest = this.json.getJsonObject("dist-tags").containsKey((Object)LATEST);
        } else {
            patch.add("/dist-tags", (JsonValue)Json.createObjectBuilder().build());
        }
        for (Map.Entry tag : uploaded.getJsonObject("dist-tags").entrySet()) {
            patch.add(String.format("/dist-tags/%s", tag.getKey()), (JsonValue)tag.getValue());
            if (!((String)tag.getKey()).equals(LATEST)) continue;
            haslatest = true;
        }
        for (Object key : keys) {
            Object version = versions.getJsonObject((String)key);
            patch.add(String.format("/versions/%s", key), (JsonValue)version);
            patch.add(String.format("/versions/%s/dist/tarball", key), String.format("/%s", new TgzRelativePath(version.getJsonObject("dist").getString("tarball")).relative()));
        }
        String now = new DateTimeNowStr().value();
        for (Object version : keys) {
            patch.add(String.format("/time/%s", version), now);
        }
        patch.add("/time/modified", now);
        if (!haslatest && !keys.isEmpty()) {
            ArrayList lst = new ArrayList(keys);
            lst.sort(Comparator.reverseOrder());
            patch.add("/dist-tags/latest", (String)lst.get(0));
        }
        return new Meta((JsonObject)patch.build().apply((JsonStructure)this.json));
    }

    public Flowable<ByteBuffer> byteFlow() {
        return Flowable.fromArray((Object[])new ByteBuffer[]{ByteBuffer.wrap(this.json.toString().getBytes(StandardCharsets.UTF_8))});
    }
}

