/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm;

import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.Storage;
import com.artipie.asto.ext.ContentDigest;
import com.artipie.asto.ext.Digests;
import com.artipie.npm.Meta;
import com.artipie.npm.NpmPublishJsonToMetaSkelethon;
import com.artipie.npm.TgzArchive;
import com.artipie.npm.misc.JsonFromPublisher;
import hu.akarnokd.rxjava2.interop.SingleInterop;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonPatchBuilder;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import org.apache.commons.codec.binary.Hex;

public interface MetaUpdate {
    public CompletableFuture<Void> update(Key var1, Storage var2);

    public static class ByTgz
    implements MetaUpdate {
        private final TgzArchive tgz;

        public ByTgz(TgzArchive tgz) {
            this.tgz = tgz;
        }

        @Override
        public CompletableFuture<Void> update(Key prefix, Storage storage) {
            String version = "version";
            JsonPatchBuilder patch = Json.createPatchBuilder();
            patch.add("/dist", (JsonValue)Json.createObjectBuilder().build());
            return ByTgz.hash(this.tgz, Digests.SHA512, true).thenAccept(sha -> patch.add("/dist/integrity", String.format("sha512-%s", sha))).thenCombine(ByTgz.hash(this.tgz, Digests.SHA1, false), (nothing, sha) -> patch.add("/dist/shasum", sha)).thenCombine((CompletionStage)this.tgz.packageJson().to(SingleInterop.get()), (nothing, pkg) -> {
                String name = pkg.getString("name");
                String vers = pkg.getString("version");
                patch.add("/_id", String.format("%s@%s", name, vers));
                patch.add("/dist/tarball", String.format("%s/-/%s-%s.tgz", prefix.string(), name, vers));
                return (JsonObject)patch.build().apply((JsonStructure)pkg);
            }).thenApply(json -> {
                JsonObject base = new NpmPublishJsonToMetaSkelethon((JsonObject)json).skeleton();
                String vers = json.getString("version");
                JsonPatchBuilder upd = Json.createPatchBuilder();
                upd.add("/dist-tags", (JsonValue)Json.createObjectBuilder().build());
                upd.add("/dist-tags/latest", vers);
                upd.add(String.format("/versions/%s", vers), (JsonValue)json);
                return (JsonObject)upd.build().apply((JsonStructure)base);
            }).thenCompose(json -> new ByJson((JsonObject)json).update(prefix, storage)).toCompletableFuture();
        }

        private static CompletionStage<String> hash(TgzArchive tgz, Digests dgst, boolean encoded) {
            return new ContentDigest((Content)new Content.From(tgz.bytes()), (Supplier)dgst).bytes().thenApply(bytes -> {
                String res = encoded ? new String(Base64.getEncoder().encode((byte[])bytes)) : Hex.encodeHexString((byte[])bytes);
                return res;
            });
        }
    }

    public static class ByJson
    implements MetaUpdate {
        private final JsonObject json;

        public ByJson(JsonObject json) {
            this.json = json;
        }

        @Override
        public CompletableFuture<Void> update(Key prefix, Storage storage) {
            Key.From keymeta = new Key.From(prefix, new String[]{"meta.json"});
            return ((CompletableFuture)((CompletableFuture)storage.exists((Key)keymeta).thenCompose(arg_0 -> this.lambda$update$0(storage, (Key)keymeta, arg_0))).thenApply(meta -> meta.updatedMeta(this.json))).thenCompose(arg_0 -> ByJson.lambda$update$2(storage, (Key)keymeta, arg_0));
        }

        private static /* synthetic */ CompletionStage lambda$update$2(Storage storage, Key keymeta, Meta meta) {
            return storage.save(keymeta, (Content)new Content.From(meta.byteFlow()));
        }

        private /* synthetic */ CompletionStage lambda$update$0(Storage storage, Key keymeta, Boolean exists) {
            CompletableFuture<Meta> meta = exists != false ? ((CompletableFuture)((CompletableFuture)storage.value(keymeta).thenApply(JsonFromPublisher::new)).thenCompose(JsonFromPublisher::json)).thenApply(Meta::new) : CompletableFuture.completedFuture(new Meta(new NpmPublishJsonToMetaSkelethon(this.json).skeleton()));
            return meta;
        }
    }
}

