/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.http.Slice;
import com.artipie.http.client.ClientSlices;
import com.artipie.http.client.UriClientSlice;
import com.artipie.npm.proxy.HttpNpmRemote;
import com.artipie.npm.proxy.NpmProxyStorage;
import com.artipie.npm.proxy.NpmRemote;
import com.artipie.npm.proxy.RxNpmProxyStorage;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import java.io.IOException;
import java.net.URI;

public class NpmProxy {
    private final NpmProxyStorage storage;
    private final NpmRemote remote;

    public NpmProxy(URI remote, Storage storage, ClientSlices client) {
        this(new RxNpmProxyStorage((RxStorage)new RxStorageWrapper(storage)), new HttpNpmRemote((Slice)new UriClientSlice(client, remote)));
    }

    public NpmProxy(Storage storage, Slice client) {
        this(new RxNpmProxyStorage((RxStorage)new RxStorageWrapper(storage)), new HttpNpmRemote(client));
    }

    NpmProxy(NpmProxyStorage storage, NpmRemote remote) {
        this.storage = storage;
        this.remote = remote;
    }

    public Maybe<NpmPackage> getPackage(String name) {
        return this.storage.getPackage(name).flatMap(pkg -> this.remotePackage(name).switchIfEmpty((MaybeSource)Maybe.just((Object)pkg))).switchIfEmpty((MaybeSource)Maybe.defer(() -> this.remotePackage(name)));
    }

    public Maybe<NpmAsset> getAsset(String path) {
        return this.storage.getAsset(path).switchIfEmpty((MaybeSource)Maybe.defer(() -> this.remote.loadAsset(path, null).flatMap(asset -> this.storage.save((NpmAsset)asset).andThen((MaybeSource)Maybe.defer(() -> this.storage.getAsset(path))))));
    }

    public void close() throws IOException {
        this.remote.close();
    }

    private Maybe<NpmPackage> remotePackage(String name) {
        Maybe<NpmPackage> pckg = this.remote.loadPackage(name);
        Maybe res = pckg == null ? Maybe.empty() : pckg.flatMap(pkg -> this.storage.save((NpmPackage)pkg).andThen((MaybeSource)Maybe.just((Object)pkg)));
        return res;
    }
}

