/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.http;

import com.artipie.asto.Storage;
import com.artipie.http.Response;
import com.artipie.http.Slice;
import com.artipie.http.auth.AuthUser;
import com.artipie.http.auth.BearerAuthzSlice;
import com.artipie.http.auth.OperationControl;
import com.artipie.http.auth.TokenAuthentication;
import com.artipie.http.rq.RqMethod;
import com.artipie.http.rs.RsStatus;
import com.artipie.http.rs.RsWithStatus;
import com.artipie.http.rt.ByMethodsRule;
import com.artipie.http.rt.RtPath;
import com.artipie.http.rt.RtRule;
import com.artipie.http.rt.RtRulePath;
import com.artipie.http.rt.SliceRoute;
import com.artipie.http.slice.SliceDownload;
import com.artipie.http.slice.SliceSimple;
import com.artipie.npm.http.AddDistTagsSlice;
import com.artipie.npm.http.CliPublish;
import com.artipie.npm.http.CurlPublish;
import com.artipie.npm.http.DeleteDistTagsSlice;
import com.artipie.npm.http.DeprecateSlice;
import com.artipie.npm.http.DownloadPackageSlice;
import com.artipie.npm.http.GetDistTagsSlice;
import com.artipie.npm.http.UnpublishForceSlice;
import com.artipie.npm.http.UnpublishPutSlice;
import com.artipie.npm.http.UploadSlice;
import com.artipie.security.perms.Action;
import com.artipie.security.perms.AdapterBasicPermission;
import com.artipie.security.policy.Policy;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.Permission;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;

public final class NpmSlice
implements Slice {
    static final TokenAuthentication ANONYMOUS = tkn -> CompletableFuture.completedFuture(Optional.of(new AuthUser("anonymous", "anonymity")));
    private static final String NPM_COMMAND = "npm-command";
    private static final String REFERER = "referer";
    private final SliceRoute route;

    public NpmSlice(URL base, Storage storage) {
        this(base, storage, Policy.FREE, ANONYMOUS, "*");
    }

    public NpmSlice(URL base, Storage storage, Policy<?> policy, TokenAuthentication auth, String name) {
        this.route = new SliceRoute(new RtPath[]{new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.GET}), new RtRule.ByPath("/npm")}), (Slice)new BearerAuthzSlice((Slice)new SliceSimple((Response)new RsWithStatus(RsStatus.OK)), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.READ)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.PUT}), new RtRule.ByPath(AddDistTagsSlice.PTRN)}), (Slice)new BearerAuthzSlice((Slice)new AddDistTagsSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.DELETE}), new RtRule.ByPath(AddDistTagsSlice.PTRN)}), (Slice)new BearerAuthzSlice((Slice)new DeleteDistTagsSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.PUT}), new RtRule.Any(new RtRule[]{new RtRule.ByHeader(NPM_COMMAND, CliPublish.HEADER), new RtRule.ByHeader(REFERER, CliPublish.HEADER)})}), (Slice)new BearerAuthzSlice((Slice)new UploadSlice(new CliPublish(storage), storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.PUT}), new RtRule.Any(new RtRule[]{new RtRule.ByHeader(NPM_COMMAND, DeprecateSlice.HEADER), new RtRule.ByHeader(REFERER, DeprecateSlice.HEADER)})}), (Slice)new BearerAuthzSlice((Slice)new DeprecateSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.PUT}), new RtRule.Any(new RtRule[]{new RtRule.ByHeader(NPM_COMMAND, UnpublishPutSlice.HEADER), new RtRule.ByHeader(REFERER, UnpublishPutSlice.HEADER)})}), (Slice)new BearerAuthzSlice((Slice)new UnpublishPutSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.PUT}), new RtRule.ByPath(CurlPublish.PTRN)}), (Slice)new BearerAuthzSlice((Slice)new UploadSlice(new CurlPublish(storage), storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.WRITE)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.GET}), new RtRule.ByPath(".*/dist-tags$")}), (Slice)new BearerAuthzSlice((Slice)new GetDistTagsSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.READ)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.GET}), new RtRule.ByPath(".*(?<!\\.tgz)$")}), (Slice)new BearerAuthzSlice((Slice)new DownloadPackageSlice(base, storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.READ)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.GET}), new RtRule.ByPath(".*\\.tgz$")}), (Slice)new BearerAuthzSlice((Slice)new SliceDownload(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.READ)))), new RtRulePath((RtRule)new RtRule.All(new RtRule[]{new ByMethodsRule(new RqMethod[]{RqMethod.DELETE}), new RtRule.ByPath(UnpublishForceSlice.PTRN)}), (Slice)new BearerAuthzSlice((Slice)new UnpublishForceSlice(storage), auth, new OperationControl(policy, (Permission)new AdapterBasicPermission(name, (Action)Action.Standard.DELETE))))});
    }

    public Response response(String line, Iterable<Map.Entry<String, String>> headers, Publisher<ByteBuffer> body) {
        return this.route.response(line, headers, body);
    }
}

