/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.asto.fs.RxFile;
import com.artipie.npm.proxy.NpmProxy;
import com.artipie.npm.proxy.NpmProxyConfig;
import com.artipie.npm.proxy.NpmRemote;
import com.artipie.npm.proxy.json.CachedContent;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import com.jcabi.log.Logger;
import io.reactivex.Maybe;
import io.vertx.core.file.OpenOptions;
import io.vertx.ext.web.client.WebClientOptions;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.core.streams.WriteStream;
import io.vertx.reactivex.ext.web.client.WebClient;
import io.vertx.reactivex.ext.web.codec.BodyCodec;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import org.reactivestreams.Publisher;

public final class HttpNpmRemote
implements NpmRemote {
    private final WebClient client;
    private final NpmProxyConfig config;
    private final Vertx vertx;

    HttpNpmRemote(NpmProxyConfig config, Vertx vertx) {
        this.config = config;
        this.vertx = vertx;
        this.client = WebClient.create((Vertx)vertx, (WebClientOptions)this.defaultWebClientOptions());
    }

    @Override
    public Maybe<NpmPackage> loadPackage(String name) {
        return this.client.getAbs(String.format("%s/%s", this.config.url(), name)).timeout((long)this.config.requestTimeout()).rxSend().flatMapMaybe(response -> {
            if (response.statusCode() == 200) {
                return Maybe.just((Object)new NpmPackage(name, new CachedContent(response.bodyAsString(), name).value(), response.getHeader("Last-Modified")));
            }
            Logger.debug(NpmProxy.class, (String)"Could not load package: status code %d", (Object[])new Object[]{response.statusCode()});
            return Maybe.empty();
        }).onErrorResumeNext(throwable -> {
            Logger.error(NpmProxy.class, (String)"Error occurred when process get package call: %s", (Object[])new Object[]{throwable.getMessage()});
            return Maybe.empty();
        });
    }

    @Override
    public Maybe<NpmAsset> loadAsset(String path, Path tmp) {
        return this.vertx.fileSystem().rxOpen(tmp.toAbsolutePath().toString(), new OpenOptions().setSync(true).setTruncateExisting(true)).flatMapMaybe(asyncfile -> this.client.getAbs(String.format("%s/%s", this.config.url(), path)).as(BodyCodec.pipe((WriteStream)asyncfile)).rxSend().flatMapMaybe(response -> {
            if (response.statusCode() == 200) {
                return Maybe.just((Object)new NpmAsset(path, (Publisher<ByteBuffer>)new RxFile(tmp, this.vertx.fileSystem()).flow(), response.getHeader("Last-Modified"), response.getHeader("Content-Type")));
            }
            Logger.debug(NpmProxy.class, (String)"Could not load asset: status code %d", (Object[])new Object[]{response.statusCode()});
            return Maybe.empty();
        })).onErrorResumeNext(throwable -> {
            Logger.error(NpmProxy.class, (String)"Error occurred when process get asset call: %s", (Object[])new Object[]{throwable.getMessage()});
            return Maybe.empty();
        });
    }

    @Override
    public void close() {
        this.client.close();
    }

    private WebClientOptions defaultWebClientOptions() {
        WebClientOptions options = new WebClientOptions();
        options.setKeepAlive(true);
        options.setUserAgent("Artipie");
        options.setConnectTimeout(this.config.connectTimeout());
        return options;
    }
}

