/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.asto.Storage;
import com.artipie.asto.rx.RxStorage;
import com.artipie.asto.rx.RxStorageWrapper;
import com.artipie.npm.proxy.HttpNpmRemote;
import com.artipie.npm.proxy.NpmProxyConfig;
import com.artipie.npm.proxy.NpmProxyStorage;
import com.artipie.npm.proxy.NpmRemote;
import com.artipie.npm.proxy.RxNpmProxyStorage;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import io.reactivex.Maybe;
import io.reactivex.MaybeSource;
import io.vertx.reactivex.core.Vertx;
import java.io.IOException;
import java.nio.file.Paths;

public class NpmProxy {
    private final Vertx vertx;
    private final NpmProxyStorage storage;
    private final NpmRemote remote;

    public NpmProxy(NpmProxyConfig config, Vertx vertx, Storage storage) {
        this(vertx, new RxNpmProxyStorage((RxStorage)new RxStorageWrapper(storage)), new HttpNpmRemote(config, vertx));
    }

    NpmProxy(Vertx vertx, NpmProxyStorage storage, NpmRemote remote) {
        this.vertx = vertx;
        this.storage = storage;
        this.remote = remote;
    }

    public Maybe<NpmPackage> getPackage(String name) {
        return this.remote.loadPackage(name).flatMap(pkg -> this.storage.save((NpmPackage)pkg).andThen((MaybeSource)Maybe.just((Object)pkg))).switchIfEmpty((MaybeSource)Maybe.defer(() -> this.storage.getPackage(name)));
    }

    public Maybe<NpmAsset> getAsset(String path) {
        return this.storage.getAsset(path).switchIfEmpty((MaybeSource)Maybe.defer(() -> this.vertx.fileSystem().rxCreateTempFile("npm-asset-", ".tmp").flatMapMaybe(tmp -> this.remote.loadAsset(path, Paths.get(tmp, new String[0])).flatMap(asset -> this.storage.save((NpmAsset)asset).andThen((MaybeSource)Maybe.defer(() -> this.storage.getAsset(path))).doOnTerminate(() -> this.vertx.fileSystem().rxDelete(tmp))))));
    }

    public void close() throws IOException {
        this.remote.close();
    }
}

