/*
 * Decompiled with CFR 0.152.
 */
package com.artipie.npm.proxy;

import com.artipie.asto.Concatenation;
import com.artipie.asto.Content;
import com.artipie.asto.Key;
import com.artipie.asto.rx.RxStorage;
import com.artipie.npm.proxy.NpmProxyStorage;
import com.artipie.npm.proxy.model.NpmAsset;
import com.artipie.npm.proxy.model.NpmPackage;
import io.reactivex.Completable;
import io.reactivex.CompletableSource;
import io.reactivex.Maybe;
import io.reactivex.Single;
import io.reactivex.SingleSource;
import io.vertx.core.json.JsonObject;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;

public final class RxNpmProxyStorage
implements NpmProxyStorage {
    private final RxStorage storage;

    public RxNpmProxyStorage(RxStorage storage) {
        this.storage = storage;
    }

    @Override
    public Completable save(NpmPackage pkg) {
        Key.From key = new Key.From(new String[]{pkg.name(), "package.json"});
        return Completable.concatArray((CompletableSource[])new CompletableSource[]{this.storage.save((Key)key, (Content)new Content.From(pkg.content().getBytes(StandardCharsets.UTF_8))), this.storage.save((Key)new Key.From(new String[]{pkg.name(), "package.metadata"}), (Content)new Content.From(RxNpmProxyStorage.packageMetadata(pkg).getBytes(StandardCharsets.UTF_8)))});
    }

    @Override
    public Completable save(NpmAsset asset) {
        Key.From key = new Key.From(asset.path());
        return Completable.concatArray((CompletableSource[])new CompletableSource[]{this.storage.save((Key)key, (Content)new Content.From(asset.dataPublisher())), this.storage.save((Key)new Key.From(String.format("%s.metadata", asset.path())), (Content)new Content.From(RxNpmProxyStorage.assetMetadata(asset).getBytes(StandardCharsets.UTF_8)))});
    }

    @Override
    public Maybe<NpmPackage> getPackage(String name) {
        return this.storage.exists((Key)new Key.From(new String[]{name, "package.json"})).flatMapMaybe(exists -> {
            if (exists.booleanValue()) {
                return this.readPackage(name).toMaybe();
            }
            return Maybe.empty();
        });
    }

    @Override
    public Maybe<NpmAsset> getAsset(String path) {
        return this.storage.exists((Key)new Key.From(path)).flatMapMaybe(exists -> {
            if (exists.booleanValue()) {
                return this.readAsset(path).toMaybe();
            }
            return Maybe.empty();
        });
    }

    private Single<NpmPackage> readPackage(String name) {
        return this.storage.value((Key)new Key.From(new String[]{name, "package.json"})).map(Concatenation::new).flatMap(Concatenation::single).zipWith((SingleSource)this.storage.value((Key)new Key.From(new String[]{name, "package.metadata"})).map(Concatenation::new).flatMap(Concatenation::single).map(metadata -> new String(metadata.array(), StandardCharsets.UTF_8)).map(JsonObject::new), (content, metadata) -> new NpmPackage(name, new String(content.array(), StandardCharsets.UTF_8), metadata.getString("last-modified")));
    }

    private Single<NpmAsset> readAsset(String path) {
        return this.storage.value((Key)new Key.From(path)).zipWith((SingleSource)this.storage.value((Key)new Key.From(String.format("%s.metadata", path))).map(Concatenation::new).flatMap(Concatenation::single).map(metadata -> new String(metadata.array(), StandardCharsets.UTF_8)).map(JsonObject::new), (content, metadata) -> new NpmAsset(path, (Publisher<ByteBuffer>)content, metadata.getString("last-modified"), metadata.getString("content-type")));
    }

    private static String packageMetadata(NpmPackage pkg) {
        JsonObject json = new JsonObject();
        json.put("last-modified", pkg.lastModified());
        return json.encode();
    }

    private static String assetMetadata(NpmAsset asset) {
        JsonObject json = new JsonObject();
        json.put("last-modified", asset.lastModified());
        json.put("content-type", asset.contentType());
        return json.encode();
    }
}

